/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.DictionaryFeatureGenerator;
import opennlp.tools.util.featuregen.GeneratorFactory;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.DictionarySerializer;

public class DictionaryFeatureGeneratorFactory
extends GeneratorFactory.AbstractXmlFeatureGeneratorFactory {
    private static final String DICT = "dict";

    @Override
    public AdaptiveFeatureGenerator create() throws InvalidFormatException {
        Dictionary d;
        block12: {
            if (this.resourceManager == null) {
                String dictResourcePath = this.getStr(DICT);
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                try (InputStream is = cl.getResourceAsStream(dictResourcePath);){
                    if (is != null) {
                        d = ((DictionarySerializer)this.getArtifactSerializerMapping().get(dictResourcePath)).create(is);
                        break block12;
                    }
                    throw new InvalidFormatException("No dictionary resource at: '" + dictResourcePath);
                }
                catch (IOException e) {
                    throw new InvalidFormatException("Error processing resource at: " + dictResourcePath, (Throwable)e);
                }
            }
            String dictResourceKey = this.getStr(DICT);
            Object dictResource = this.resourceManager.getResource(dictResourceKey);
            if (dictResource instanceof Dictionary) {
                Dictionary dict;
                d = dict = (Dictionary)dictResource;
            } else {
                throw new InvalidFormatException("No dictionary resource for key: " + dictResourceKey);
            }
        }
        return new DictionaryFeatureGenerator(d);
    }

    @Override
    public Map<String, ArtifactSerializer<?>> getArtifactSerializerMapping() throws InvalidFormatException {
        HashMap mapping = new HashMap();
        mapping.put(this.getStr(DICT), new DictionarySerializer());
        return mapping;
    }
}

