/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.formats.FormatUtil;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;

public abstract class AbstractSampleStreamFactory<T, P>
implements ObjectStreamFactory<T, P> {
    protected Class<P> params;

    private AbstractSampleStreamFactory() {
    }

    protected AbstractSampleStreamFactory(Class<P> params) {
        this.params = params;
    }

    public String getLang() {
        return "eng";
    }

    public Class<P> getParameters() {
        return this.params;
    }

    protected <P extends BasicFormatParams> ObjectStream<String> readData(String[] args, Class<P> parametersClass) {
        P params = this.validateBasicFormatParameters(args, parametersClass);
        PlainTextByLineStream lineStream = null;
        try {
            InputStreamFactory sampleDataIn = FormatUtil.createInputStreamFactory(params.getData());
            lineStream = new PlainTextByLineStream(sampleDataIn, params.getEncoding());
        }
        catch (IOException ex) {
            throw new TerminateToolException(-1, "IO Error while creating an Input Stream: " + ex.getMessage(), (Throwable)ex);
        }
        return lineStream;
    }

    protected <P extends BasicFormatParams> P validateBasicFormatParameters(String[] args, Class<P> clazz) {
        if (args == null) {
            throw new IllegalArgumentException("Passed args must not be null!");
        }
        BasicFormatParams params = (BasicFormatParams)ArgumentParser.parse((String[])args, clazz);
        FormatUtil.checkInputFile("Data", params.getData());
        return (P)params;
    }
}

