/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.lemmatizer;

import java.io.File;
import java.io.IOException;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.SystemInputStreamFactory;
import opennlp.tools.cmdline.lemmatizer.LemmatizerModelLoader;
import opennlp.tools.lemmatizer.LemmaSample;
import opennlp.tools.lemmatizer.LemmatizerME;
import opennlp.tools.lemmatizer.LemmatizerModel;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.PlainTextByLineStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LemmatizerMETool
extends BasicCmdLineTool {
    private static final Logger logger = LoggerFactory.getLogger(LemmatizerMETool.class);

    @Override
    public String getShortDescription() {
        return "Learnable lemmatizer";
    }

    @Override
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " model < sentences";
    }

    @Override
    public void run(String[] args) {
        if (args.length != 1) {
            logger.info(this.getHelp());
        } else {
            LemmatizerModel model = (LemmatizerModel)new LemmatizerModelLoader().load(new File(args[0]));
            LemmatizerME lemmatizer = new LemmatizerME(model);
            PerformanceMonitor perfMon = null;
            try (PlainTextByLineStream lineStream = new PlainTextByLineStream((InputStreamFactory)new SystemInputStreamFactory(), SystemInputStreamFactory.encoding());){
                String line;
                perfMon = new PerformanceMonitor("sent");
                perfMon.start();
                while ((line = (String)lineStream.read()) != null) {
                    POSSample posSample;
                    try {
                        posSample = POSSample.parse((String)line);
                    }
                    catch (InvalidFormatException e) {
                        logger.warn("Invalid format: {}", (Object)line);
                        continue;
                    }
                    String[] lemmas = lemmatizer.lemmatize(posSample.getSentence(), posSample.getTags());
                    logger.info(new LemmaSample(posSample.getSentence(), posSample.getTags(), lemmas).toString());
                    perfMon.incrementCounter();
                }
            }
            catch (IOException e) {
                CmdLineUtil.handleStdinIoError(e);
            }
            perfMon.stopAndPrintFinalResult();
        }
    }
}

