/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.util.Assert;

public class TestingAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 1L;
    private final Object credentials;
    private final Object principal;

    public TestingAuthenticationToken(Object principal, Object credentials) {
        super((Collection<? extends GrantedAuthority>)null);
        this.principal = principal;
        this.credentials = credentials;
    }

    public TestingAuthenticationToken(Object principal, Object credentials, String ... authorities) {
        this(principal, credentials, AuthorityUtils.createAuthorityList(authorities));
    }

    public TestingAuthenticationToken(Object principal, Object credentials, GrantedAuthority ... authorities) {
        this(principal, credentials, Arrays.asList(authorities));
    }

    public TestingAuthenticationToken(Object principal, Object credentials, List<? extends GrantedAuthority> authorities) {
        this(principal, credentials, (Collection<? extends GrantedAuthority>)authorities);
    }

    public TestingAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.principal = principal;
        this.credentials = credentials;
        this.setAuthenticated(true);
    }

    protected TestingAuthenticationToken(Builder<?> builder) {
        super(builder);
        this.principal = builder.principal;
        this.credentials = builder.credentials;
    }

    @Override
    public Object getCredentials() {
        return this.credentials;
    }

    @Override
    public Object getPrincipal() {
        return this.principal;
    }

    public Builder<?> toBuilder() {
        return new Builder(this);
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAuthenticationToken.AbstractAuthenticationBuilder<B> {
        private Object principal;
        private Object credentials;

        protected Builder(TestingAuthenticationToken token) {
            super(token);
            this.principal = token.principal;
            this.credentials = token.credentials;
        }

        @Override
        public B principal(@Nullable Object principal) {
            Assert.notNull((Object)principal, (String)"principal cannot be null");
            this.principal = principal;
            return (B)this;
        }

        @Override
        public B credentials(@Nullable Object credentials) {
            Assert.notNull((Object)credentials, (String)"credentials cannot be null");
            this.credentials = credentials;
            return (B)this;
        }

        @Override
        public TestingAuthenticationToken build() {
            return new TestingAuthenticationToken(this);
        }
    }
}

