/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.multipart;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.internal.multipart.MultipartDownloadResumeContext;
import software.amazon.awssdk.services.s3.internal.multipart.MultipartDownloadUtils;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.ContentRangeParser;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Pair;

@SdkInternalApi
public class ParallelMultipartDownloaderSubscriber
implements Subscriber<AsyncResponseTransformer<GetObjectResponse, GetObjectResponse>> {
    private static final Logger log = Logger.loggerFor(ParallelMultipartDownloaderSubscriber.class);
    private final int maxInFlightParts;
    private final S3AsyncClient s3;
    private final GetObjectRequest getObjectRequest;
    private final AtomicInteger completedParts;
    private final CompletableFuture<GetObjectResponse> resultFuture;
    private volatile GetObjectResponse getObjectResponse;
    private Subscription subscription;
    private CompletableFuture<Integer> totalPartsFuture = new CompletableFuture();
    private volatile String eTag;
    private final Object subscriptionLock = new Object();
    private final Map<Integer, CompletableFuture<GetObjectResponse>> inFlightRequests = new ConcurrentHashMap<Integer, CompletableFuture<GetObjectResponse>>();
    private final AtomicInteger inFlightRequestsNum = new AtomicInteger(0);
    private final Queue<Pair<Integer, AsyncResponseTransformer<GetObjectResponse, GetObjectResponse>>> pendingTransformers = new ConcurrentLinkedQueue<Pair<Integer, AsyncResponseTransformer<GetObjectResponse, GetObjectResponse>>>();
    private final AtomicInteger outstandingDemand = new AtomicInteger(0);
    private final AtomicBoolean processingPendingTransformers = new AtomicBoolean(false);
    private final AtomicInteger partNumber = new AtomicInteger(0);
    private final AtomicBoolean isCompletedExceptionally = new AtomicBoolean(false);
    private final Set<Integer> initialCompletedParts;

    public ParallelMultipartDownloaderSubscriber(S3AsyncClient s3, GetObjectRequest getObjectRequest, CompletableFuture<GetObjectResponse> resultFuture, int maxInFlightParts) {
        this.s3 = s3;
        this.getObjectRequest = getObjectRequest;
        this.resultFuture = resultFuture;
        this.maxInFlightParts = maxInFlightParts;
        this.initialCompletedParts = ParallelMultipartDownloaderSubscriber.initialCompletedParts(getObjectRequest);
        this.completedParts = new AtomicInteger(this.initialCompletedParts.size());
        if (this.resumingDownload()) {
            int totalPartsFromInitialRequest = MultipartDownloadUtils.multipartDownloadResumeContext(getObjectRequest).map(MultipartDownloadResumeContext::totalParts).orElse(0);
            if (totalPartsFromInitialRequest > 0) {
                this.totalPartsFuture.complete(totalPartsFromInitialRequest);
            }
            this.getObjectResponse = MultipartDownloadUtils.multipartDownloadResumeContext(getObjectRequest).map(MultipartDownloadResumeContext::response).orElse(null);
        }
    }

    private static Set<Integer> initialCompletedParts(GetObjectRequest getObjectRequest) {
        return Collections.unmodifiableSet(MultipartDownloadUtils.multipartDownloadResumeContext(getObjectRequest).map(MultipartDownloadResumeContext::completedParts).map(HashSet::new).orElse(Collections.emptySet()));
    }

    private boolean resumingDownload() {
        Optional<Boolean> hasAlreadyCompletedParts = MultipartDownloadUtils.multipartDownloadResumeContext(this.getObjectRequest).map(ctx -> !ctx.completedParts().isEmpty());
        return hasAlreadyCompletedParts.orElse(false);
    }

    public void onSubscribe(Subscription s) {
        if (this.subscription != null) {
            s.cancel();
            return;
        }
        this.subscription = s;
        this.subscription.request((long)this.maxInFlightParts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(AsyncResponseTransformer<GetObjectResponse, GetObjectResponse> asyncResponseTransformer) {
        if (asyncResponseTransformer == null) {
            Object object = this.subscriptionLock;
            synchronized (object) {
                this.subscription.cancel();
            }
            throw new NullPointerException("onNext must not be called with null asyncResponseTransformer");
        }
        log.trace(() -> "On Next - Total in flight parts: " + this.inFlightRequests.size() + " - Demand : " + this.outstandingDemand.get() + " - Total completed parts: " + this.completedParts + " - Total pending transformers: " + this.pendingTransformers.size() + " - Current in flight requests: " + this.inFlightRequests.keySet());
        int currentPartNum = this.nextPart();
        if (currentPartNum == 1) {
            this.sendFirstRequest(asyncResponseTransformer);
        } else {
            this.totalPartsFuture.thenAccept(totalParts -> {
                if (currentPartNum <= totalParts) {
                    this.processingRequests(asyncResponseTransformer, currentPartNum, (int)totalParts);
                }
            });
        }
    }

    private void processingRequests(AsyncResponseTransformer<GetObjectResponse, GetObjectResponse> asyncResponseTransformer, int currentPartNum, int totalParts) {
        if (currentPartNum > totalParts) {
            return;
        }
        if (this.inFlightRequests.size() >= this.maxInFlightParts) {
            this.pendingTransformers.offer((Pair<Integer, AsyncResponseTransformer<GetObjectResponse, GetObjectResponse>>)Pair.of((Object)currentPartNum, asyncResponseTransformer));
            return;
        }
        this.sendNextRequest(asyncResponseTransformer, currentPartNum, totalParts);
        this.processPendingTransformers(totalParts);
    }

    private void sendNextRequest(AsyncResponseTransformer<GetObjectResponse, GetObjectResponse> asyncResponseTransformer, int currentPartNumber, int totalParts) {
        if (this.inFlightRequestsNum.get() + this.completedParts.get() >= totalParts) {
            return;
        }
        GetObjectRequest request = this.nextRequest(currentPartNumber);
        log.debug(() -> "Sending next request for part: " + currentPartNumber);
        CompletableFuture<GetObjectResponse> response = this.s3.getObject(request, asyncResponseTransformer);
        this.inFlightRequests.put(currentPartNumber, response);
        CompletableFutureUtils.forwardExceptionTo(this.resultFuture, response);
        response.whenComplete((res, e) -> {
            if (e != null || this.isCompletedExceptionally.get()) {
                this.handlePartError((Throwable)e, currentPartNumber);
                return;
            }
            log.debug(() -> "Completed part: " + currentPartNumber);
            this.inFlightRequests.remove(currentPartNumber);
            this.completedParts.incrementAndGet();
            MultipartDownloadUtils.multipartDownloadResumeContext(this.getObjectRequest).ifPresent(ctx -> ctx.addCompletedPart(currentPartNumber));
            if (this.completedParts.get() >= totalParts) {
                if (this.completedParts.get() > totalParts) {
                    this.resultFuture.completeExceptionally(new IllegalStateException("Total parts exceeded"));
                } else {
                    this.updateResumeContextForCompletion((GetObjectResponse)((Object)res));
                    this.resultFuture.complete(this.getObjectResponse);
                }
                Object object = this.subscriptionLock;
                synchronized (object) {
                    this.subscription.cancel();
                }
            }
            this.processPendingTransformers(res.partsCount());
            Object object = this.subscriptionLock;
            synchronized (object) {
                this.subscription.request(1L);
            }
        });
    }

    private void updateResumeContextForCompletion(GetObjectResponse response) {
        ContentRangeParser.totalBytes((String)response.contentRange()).ifPresent(total -> MultipartDownloadUtils.multipartDownloadResumeContext(this.getObjectRequest).ifPresent(ctx -> ctx.addToBytesToLastCompletedParts(total)));
    }

    private void sendFirstRequest(AsyncResponseTransformer<GetObjectResponse, GetObjectResponse> asyncResponseTransformer) {
        log.debug(() -> "Sending first request");
        GetObjectRequest request = this.nextRequest(1);
        CompletableFuture<GetObjectResponse> responseFuture = this.s3.getObject(request, asyncResponseTransformer);
        CompletableFutureUtils.forwardExceptionTo(this.resultFuture, responseFuture);
        responseFuture.whenComplete((res, e) -> {
            if (e != null || this.isCompletedExceptionally.get()) {
                this.handlePartError((Throwable)e, 1);
                return;
            }
            log.debug(() -> "Completed part: 1");
            this.completedParts.incrementAndGet();
            this.setInitialPartCountAndEtag((GetObjectResponse)((Object)res));
            if (!this.isMultipartObject((GetObjectResponse)((Object)res))) {
                return;
            }
            log.debug(() -> "Multipart object detected, performing multipart download");
            this.getObjectResponse = res;
            this.processPendingTransformers(res.partsCount());
            MultipartDownloadUtils.multipartDownloadResumeContext(this.getObjectRequest).ifPresent(ctx -> {
                ctx.addCompletedPart(1);
                ctx.response((GetObjectResponse)((Object)res));
                ctx.totalParts(res.partsCount());
            });
            Object object = this.subscriptionLock;
            synchronized (object) {
                this.subscription.request(1L);
            }
        });
    }

    private boolean isMultipartObject(GetObjectResponse response) {
        if (response.partsCount() == null || response.partsCount() == 1) {
            log.debug(() -> "Single Part object detected, skipping multipart download");
            this.subscription.cancel();
            this.resultFuture.complete(response);
            return false;
        }
        return true;
    }

    private void setInitialPartCountAndEtag(GetObjectResponse response) {
        Integer partCount = response.partsCount();
        this.eTag = response.eTag();
        if (partCount != null) {
            log.debug(() -> String.format("Total amount of parts of the object to download: %d", partCount));
            this.totalPartsFuture.complete(partCount);
        } else {
            this.totalPartsFuture.complete(1);
        }
    }

    private void handlePartError(Throwable e, int part) {
        this.isCompletedExceptionally.set(true);
        log.debug(() -> "Error on part " + part, e);
        this.resultFuture.completeExceptionally(e);
        this.inFlightRequests.values().forEach(future -> future.cancel(true));
    }

    private void processPendingTransformers(int totalParts) {
        do {
            if (!this.processingPendingTransformers.compareAndSet(false, true)) {
                return;
            }
            try {
                this.doProcessPendingTransformers(totalParts);
            }
            finally {
                this.processingPendingTransformers.set(false);
            }
        } while (this.shouldProcessPendingTransformers());
    }

    private void doProcessPendingTransformers(int totalParts) {
        while (this.shouldProcessPendingTransformers()) {
            Pair<Integer, AsyncResponseTransformer<GetObjectResponse, GetObjectResponse>> pair = this.pendingTransformers.poll();
            Integer part = (Integer)pair.left();
            AsyncResponseTransformer transformer = (AsyncResponseTransformer)pair.right();
            if (part > totalParts) continue;
            this.sendNextRequest((AsyncResponseTransformer<GetObjectResponse, GetObjectResponse>)transformer, part, totalParts);
        }
    }

    private boolean shouldProcessPendingTransformers() {
        if (this.pendingTransformers.isEmpty()) {
            return false;
        }
        return this.maxInFlightParts - this.inFlightRequestsNum.get() > 0;
    }

    public void onError(Throwable t) {
        this.inFlightRequests.values().forEach(future -> future.cancel(true));
        this.inFlightRequests.clear();
        this.resultFuture.completeExceptionally(t);
    }

    public void onComplete() {
    }

    private GetObjectRequest nextRequest(int nextPartToGet) {
        return (GetObjectRequest)this.getObjectRequest.copy(req -> {
            req.partNumber(nextPartToGet);
            if (this.eTag != null) {
                req.ifMatch(this.eTag);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int nextPart() {
        if (this.initialCompletedParts.isEmpty()) {
            return this.partNumber.incrementAndGet();
        }
        Set<Integer> set = this.initialCompletedParts;
        synchronized (set) {
            int part = this.partNumber.incrementAndGet();
            while (this.initialCompletedParts.contains(part)) {
                int finalPart = part;
                log.debug(() -> "skipping part " + finalPart + " because already completed");
                part = this.partNumber.incrementAndGet();
            }
            return part;
        }
    }
}

