/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.net.mock;

import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.logging.log4j.core.test.internal.annotation.SuppressFBWarnings;
import org.apache.logging.log4j.core.test.net.mock.MockSyslogServer;

public class MockTcpSyslogServer
extends MockSyslogServer {
    private final ServerSocket serverSocket;
    private volatile boolean shutdown = false;
    private Thread thread;

    public MockTcpSyslogServer(int numberOfMessagesToReceive, int port) throws IOException {
        this(port);
    }

    public MockTcpSyslogServer() throws IOException {
        this(0);
    }

    @SuppressFBWarnings(value={"UNENCRYPTED_SERVER_SOCKET"})
    private MockTcpSyslogServer(int port) throws IOException {
        super(0, port);
        this.serverSocket = new ServerSocket(port);
    }

    @Override
    public int getLocalPort() {
        return this.serverSocket.getLocalPort();
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        try {
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (Exception e) {
                    LOGGER.error("The {} failed to close its socket.", (Object)this.getName(), (Object)e);
                }
            }
            this.interrupt();
        }
        catch (SecurityException e) {
            LOGGER.error("Shutdown of {} failed", (Object)this.getName(), (Object)e);
        }
        if (this.thread != null) {
            try {
                this.thread.join(100L);
            }
            catch (InterruptedException e) {
                LOGGER.error("Shutdown of {} thread failed.", (Object)this.getName(), (Object)e);
            }
        }
    }

    @Override
    public void run() {
        LOGGER.info("{} started on port {}.", (Object)this.getName(), (Object)this.getLocalPort());
        this.thread = Thread.currentThread();
        while (!this.shutdown) {
            try {
                byte[] buffer = new byte[4096];
                Socket socket = this.serverSocket.accept();
                try {
                    socket.setSoLinger(true, 0);
                    InputStream in = socket.getInputStream();
                    int i = in.read(buffer, 0, buffer.length);
                    while (i != -1) {
                        if (i < buffer.length) {
                            String line = new String(buffer, 0, i);
                            this.messageList.add(line);
                            i = in.read(buffer, 0, buffer.length);
                            continue;
                        }
                        if (i == 0) {
                            LOGGER.warn("{} received no data.", (Object)this.getName());
                            continue;
                        }
                        LOGGER.warn("{} received a message longer than {}.", (Object)this.getName(), (Object)buffer.length);
                    }
                }
                finally {
                    if (socket == null) continue;
                    socket.close();
                }
            }
            catch (Exception e) {
                if (this.shutdown) continue;
                LOGGER.error("{} caught an exception.", (Object)this.getName(), (Object)e);
            }
        }
        LOGGER.info("{} stopped.", (Object)this.getName());
    }
}

