/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Scanner;
import org.apache.kyuubi.jdbc.hive.KyuubiConnection;
import org.apache.kyuubi.jdbc.hive.KyuubiSQLException;
import org.apache.kyuubi.jdbc.hive.KyuubiStatement;
import org.apache.kyuubi.jdbc.hive.Utils;
import org.apache.kyuubi.jdbc.hive.adapter.SQLPreparedStatement;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TCLIService;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TSessionHandle;

public class KyuubiPreparedStatement
extends KyuubiStatement
implements SQLPreparedStatement {
    private final String sql;
    private final HashMap<Integer, String> parameters = new HashMap();

    public KyuubiPreparedStatement(KyuubiConnection connection, TCLIService.Iface client, TSessionHandle sessHandle, String sql) {
        super(connection, client, sessHandle);
        this.sql = sql;
    }

    @Override
    public void clearParameters() throws SQLException {
        this.parameters.clear();
    }

    @Override
    public boolean execute() throws SQLException {
        return super.execute(this.updateSql(this.sql, this.parameters));
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return super.executeQuery(this.updateSql(this.sql, this.parameters));
    }

    @Override
    public int executeUpdate() throws SQLException {
        super.executeUpdate(this.updateSql(this.sql, this.parameters));
        return 0;
    }

    private String updateSql(String sql, HashMap<Integer, String> parameters) throws SQLException {
        return Utils.updateSql(sql, parameters);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.parameters.put(parameterIndex, x.toString());
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        String str = new Scanner(x, "UTF-8").useDelimiter("\\A").next();
        this.setString(parameterIndex, str);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.parameters.put(parameterIndex, "" + x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.parameters.put(parameterIndex, "" + x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.parameters.put(parameterIndex, "'" + x.toString() + "'");
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.parameters.put(parameterIndex, "" + x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.parameters.put(parameterIndex, "" + x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.parameters.put(parameterIndex, "" + x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.parameters.put(parameterIndex, "" + x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.parameters.put(parameterIndex, "NULL");
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.parameters.put(paramIndex, "NULL");
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 0);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (x instanceof Character) {
            this.setString(parameterIndex, x.toString());
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof BigDecimal) {
            this.setString(parameterIndex, x.toString());
        } else {
            throw new KyuubiSQLException(MessageFormat.format("Cannot infer the SQL type to use for an instance of {0}. Use setObject() with an explicit Types value to specify the type to use.", x.getClass().getName()));
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.parameters.put(parameterIndex, "" + x);
    }

    private String replaceBackSlashSingleQuote(String x) {
        StringBuffer newX = new StringBuffer();
        for (int i = 0; i < x.length(); ++i) {
            char c = x.charAt(i);
            if (c == '\\' && i < x.length() - 1) {
                char c1 = x.charAt(i + 1);
                if (c1 == '\'') {
                    newX.append(c1);
                } else {
                    newX.append(c);
                    newX.append(c1);
                }
                ++i;
                continue;
            }
            newX.append(c);
        }
        return newX.toString();
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        x = this.replaceBackSlashSingleQuote(x);
        x = x.replace("'", "\\'");
        this.parameters.put(parameterIndex, "'" + x + "'");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.parameters.put(parameterIndex, "'" + x.toString() + "'");
    }
}

