/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ObjectMetricSource;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ObjectMetricSourceFluent<A extends ObjectMetricSourceFluent<A>>
extends BaseFluent<A> {
    private Quantity averageValue;
    private String metricName;
    private LabelSelectorBuilder selector;
    private CrossVersionObjectReferenceBuilder target;
    private Quantity targetValue;
    private Map<String, Object> additionalProperties;

    public ObjectMetricSourceFluent() {
    }

    public ObjectMetricSourceFluent(ObjectMetricSource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ObjectMetricSource instance) {
        ObjectMetricSource objectMetricSource = instance = instance != null ? instance : new ObjectMetricSource();
        if (instance != null) {
            this.withAverageValue(instance.getAverageValue());
            this.withMetricName(instance.getMetricName());
            this.withSelector(instance.getSelector());
            this.withTarget(instance.getTarget());
            this.withTargetValue(instance.getTargetValue());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Quantity getAverageValue() {
        return this.averageValue;
    }

    public A withAverageValue(Quantity averageValue) {
        this.averageValue = averageValue;
        return (A)((Object)this);
    }

    public boolean hasAverageValue() {
        return this.averageValue != null;
    }

    public A withNewAverageValue(String amount, String format) {
        return this.withAverageValue(new Quantity(amount, format));
    }

    public A withNewAverageValue(String amount) {
        return this.withAverageValue(new Quantity(amount));
    }

    public String getMetricName() {
        return this.metricName;
    }

    public A withMetricName(String metricName) {
        this.metricName = metricName;
        return (A)((Object)this);
    }

    public boolean hasMetricName() {
        return this.metricName != null;
    }

    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    public A withSelector(LabelSelector selector) {
        this._visitables.remove((Object)"selector");
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get((Object)"selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get((Object)"selector").remove(this.selector);
        }
        return (A)((Object)this);
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public SelectorNested<A> withNewSelector() {
        return new SelectorNested(null);
    }

    public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNested(item);
    }

    public SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(null));
    }

    public SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(item));
    }

    public CrossVersionObjectReference buildTarget() {
        return this.target != null ? this.target.build() : null;
    }

    public A withTarget(CrossVersionObjectReference target) {
        this._visitables.remove((Object)"target");
        if (target != null) {
            this.target = new CrossVersionObjectReferenceBuilder(target);
            this._visitables.get((Object)"target").add(this.target);
        } else {
            this.target = null;
            this._visitables.get((Object)"target").remove((Object)this.target);
        }
        return (A)((Object)this);
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    public A withNewTarget(String apiVersion, String kind, String name) {
        return this.withTarget(new CrossVersionObjectReference(apiVersion, kind, name));
    }

    public TargetNested<A> withNewTarget() {
        return new TargetNested(null);
    }

    public TargetNested<A> withNewTargetLike(CrossVersionObjectReference item) {
        return new TargetNested(item);
    }

    public TargetNested<A> editTarget() {
        return this.withNewTargetLike(Optional.ofNullable(this.buildTarget()).orElse(null));
    }

    public TargetNested<A> editOrNewTarget() {
        return this.withNewTargetLike(Optional.ofNullable(this.buildTarget()).orElse(new CrossVersionObjectReferenceBuilder().build()));
    }

    public TargetNested<A> editOrNewTargetLike(CrossVersionObjectReference item) {
        return this.withNewTargetLike(Optional.ofNullable(this.buildTarget()).orElse(item));
    }

    public Quantity getTargetValue() {
        return this.targetValue;
    }

    public A withTargetValue(Quantity targetValue) {
        this.targetValue = targetValue;
        return (A)((Object)this);
    }

    public boolean hasTargetValue() {
        return this.targetValue != null;
    }

    public A withNewTargetValue(String amount, String format) {
        return this.withTargetValue(new Quantity(amount, format));
    }

    public A withNewTargetValue(String amount) {
        return this.withTargetValue(new Quantity(amount));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectMetricSourceFluent that = (ObjectMetricSourceFluent)((Object)o);
        if (!Objects.equals(this.averageValue, that.averageValue)) {
            return false;
        }
        if (!Objects.equals(this.metricName, that.metricName)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        if (!Objects.equals((Object)this.target, (Object)that.target)) {
            return false;
        }
        if (!Objects.equals(this.targetValue, that.targetValue)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.averageValue, this.metricName, this.selector, this.target, this.targetValue, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.averageValue != null) {
            sb.append("averageValue:");
            sb.append(this.averageValue + ",");
        }
        if (this.metricName != null) {
            sb.append("metricName:");
            sb.append(this.metricName + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.target != null) {
            sb.append("target:");
            sb.append((Object)((Object)this.target) + ",");
        }
        if (this.targetValue != null) {
            sb.append("targetValue:");
            sb.append(this.targetValue + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TargetNested<N>
    extends CrossVersionObjectReferenceFluent<TargetNested<N>>
    implements Nested<N> {
        CrossVersionObjectReferenceBuilder builder;

        TargetNested(CrossVersionObjectReference item) {
            this.builder = new CrossVersionObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)ObjectMetricSourceFluent.this.withTarget(this.builder.build());
        }

        public N endTarget() {
            return this.and();
        }
    }

    public class SelectorNested<N>
    extends LabelSelectorFluent<SelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        SelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)ObjectMetricSourceFluent.this.withSelector(this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }
}

