/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.metadata.PartitionRegistration;

public final class LocalReplicaChanges {
    private final Set<TopicPartition> deletes;
    private final Map<TopicPartition, PartitionInfo> electedLeaders;
    private final Map<TopicPartition, PartitionInfo> leaders;
    private final Map<TopicPartition, PartitionInfo> followers;
    private final Map<String, Uuid> topicIds;
    private final Map<TopicIdPartition, Uuid> directoryIds;

    LocalReplicaChanges(Set<TopicPartition> deletes, Map<TopicPartition, PartitionInfo> electedLeaders, Map<TopicPartition, PartitionInfo> leaders, Map<TopicPartition, PartitionInfo> followers, Map<String, Uuid> topicIds, Map<TopicIdPartition, Uuid> directoryIds) {
        this.deletes = deletes;
        this.electedLeaders = electedLeaders;
        this.leaders = leaders;
        this.followers = followers;
        this.topicIds = topicIds;
        this.directoryIds = directoryIds;
    }

    public Set<TopicPartition> deletes() {
        return this.deletes;
    }

    public Map<TopicPartition, PartitionInfo> electedLeaders() {
        return this.electedLeaders;
    }

    public Map<TopicPartition, PartitionInfo> leaders() {
        return this.leaders;
    }

    public Map<TopicPartition, PartitionInfo> followers() {
        return this.followers;
    }

    public Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    public Map<TopicIdPartition, Uuid> directoryIds() {
        return this.directoryIds;
    }

    public String toString() {
        return String.format("LocalReplicaChanges(deletes = %s, newly elected leaders = %s, leaders = %s, followers = %s, topicIds = %s, directoryIds = %s)", this.deletes, this.electedLeaders, this.leaders, this.followers, this.topicIds, this.directoryIds);
    }

    public record PartitionInfo(Uuid topicId, PartitionRegistration partition) {
    }
}

