/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.sys;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.IOX;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.dboe.DBOpEnvException;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.dboe.sys.IO_DB;
import org.apache.jena.dboe.transaction.txn.TransactionCoordinator;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.store.DatasetGraphSwitchable;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.sys.CopyDSG;
import org.apache.jena.tdb2.sys.FilenameUtils;
import org.apache.jena.tdb2.sys.StoreConnection;
import org.apache.jena.tdb2.sys.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DatabaseOpsWindows {
    private static Logger LOG = LoggerFactory.getLogger(DatabaseOpsWindows.class);
    static final String dbPrefix = "Data";
    static final String SEP = "-";
    static final String startCount = "0001";
    private static Object compactionLock = new Object();
    private static Pattern numberPattern = Pattern.compile("[\\d]+");

    DatabaseOpsWindows() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void compact_win(DatasetGraphSwitchable container, boolean shouldDeleteOld) {
        DatabaseOpsWindows.checkSupportsAdmin(container);
        Object object = compactionLock;
        synchronized (object) {
            Path base = container.getContainerPath();
            Path db1 = DatabaseOpsWindows.findLocation(base, dbPrefix);
            if (db1 == null) {
                throw new TDBException("No location: (" + String.valueOf(base) + ", Data)");
            }
            Location loc1 = IO_DB.asLocation((Path)db1);
            Location loc1a = ((DatasetGraphTDB)container.get()).getLocation();
            if (!loc1a.exists()) {
                throw new TDBException("No such location: " + String.valueOf(loc1a));
            }
            if (!loc1.equals((Object)loc1a)) {
                throw new TDBException("Inconsistent (not latest?) : " + String.valueOf(loc1a) + " : " + String.valueOf(loc1));
            }
            int v = DatabaseOpsWindows.extractIndexX(db1.getFileName().toString(), dbPrefix, SEP);
            String next = FilenameUtils.filename(dbPrefix, SEP, v + 1);
            Path db2 = db1.getParent().resolve(next);
            Path inProgress = base.resolve("jena-tdb-temp-files");
            try {
                Files.writeString(inProgress, (CharSequence)(db2.toAbsolutePath().toString() + "\n"), new OpenOption[0]);
            }
            catch (IOException ex) {
                try {
                    Files.delete(inProgress);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw IOX.exception((IOException)ex);
            }
            IOX.createDirectory((Path)db2);
            Location loc2 = IO_DB.asLocation((Path)db2);
            LOG.debug(String.format("Compact %s -> %s\n", db1.getFileName(), db2.getFileName()));
            try {
                DatabaseOpsWindows.compaction_win(container, loc1, loc2);
            }
            catch (RuntimeIOException ex) {
                try {
                    IO.deleteAll((Path)db2);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw ex;
            }
            catch (Throwable th) {
                try {
                    IO.deleteAll((Path)db2);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw th;
            }
            try {
                Files.delete(inProgress);
            }
            catch (IOException ex) {
                throw IOX.exception((IOException)ex);
            }
            if (shouldDeleteOld) {
                Path loc1Path = IO_DB.asPath((Location)loc1);
                LOG.warn("Database will not be fully deleted until after a server restart: (old db path='" + String.valueOf(loc1Path) + "')");
                DatabaseOpsWindows.deleteDatabase(loc1Path);
            }
        }
    }

    private static void compaction_win(DatasetGraphSwitchable container, Location loc1, Location loc2) {
        if (loc1.isMem() || loc2.isMem()) {
            throw new TDBException("Compact involves a memory location: " + String.valueOf(loc1) + " : " + String.valueOf(loc2));
        }
        StoreConnection srcConn = StoreConnection.connectExisting(loc1);
        if (srcConn == null) {
            throw new TDBException("No database at location : " + String.valueOf(loc1));
        }
        if (!(container.get() instanceof DatasetGraphTDB)) {
            throw new TDBException("Not a TDB2 database in DatasetGraphSwitchable");
        }
        DatasetGraphTDB dsgCurrent = (DatasetGraphTDB)container.get();
        if (!dsgCurrent.getLocation().equals((Object)loc1)) {
            throw new TDBException("Inconsistent locations for base : " + String.valueOf(dsgCurrent.getLocation()) + " , " + String.valueOf(dsgCurrent.getLocation()));
        }
        DatasetGraphTDB dsgBase = srcConn.getDatasetGraphTDB();
        if (dsgBase != dsgCurrent) {
            throw new TDBException("Inconsistent datasets : " + String.valueOf(dsgCurrent.getLocation()) + " , " + String.valueOf(dsgBase.getLocation()));
        }
        TransactionCoordinator txnMgr1 = dsgBase.getTxnSystem().getTxnMgr();
        container.execReadOnlyDatabase(() -> {
            DatabaseOpsWindows.copyConfigFiles(loc1, loc2);
            DatasetGraphTDB dsgCompact = StoreConnection.connectCreate(loc2).getDatasetGraphTDB();
            CopyDSG.copy((DatasetGraph)dsgBase, (DatasetGraph)dsgCompact);
            TransactionCoordinator txnMgr2 = dsgCompact.getTxnSystem().getTxnMgr();
            txnMgr2.execExclusive(() -> {
                txnMgr2.takeOverFrom(txnMgr1);
                txnMgr2.modifyConfigDirect(() -> txnMgr1.listExternals().forEach(arg_0 -> ((TransactionCoordinator)txnMgr2).addExternal(arg_0)));
                if (!container.change((DatasetGraph)dsgCurrent, (DatasetGraph)dsgCompact)) {
                    Log.warn(DatabaseOpsWindows.class, (String)"Inconsistent: old datasetgraph not as expected");
                    container.set((DatasetGraph)dsgCompact);
                }
            });
        });
        txnMgr1.startExclusiveMode();
        StoreConnection.release(dsgBase.getLocation());
    }

    private static void deleteDatabase(Path locationPath) {
        try (Stream<Path> walk = Files.walk(locationPath, new FileVisitOption[0]);){
            walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException ex) {
            throw IOX.exception((IOException)ex);
        }
    }

    private static void copyConfigFiles(Location loc1, Location loc2) {
        FileFilter copyFiles = pathname -> {
            String fn = pathname.getName();
            if (fn.equals("tdb.cfg")) {
                return true;
            }
            return fn.endsWith(".opt");
        };
        File d = new File(loc1.getDirectoryPath());
        File[] files = d.listFiles(copyFiles);
        DatabaseOpsWindows.copyFiles(loc1, loc2, files);
    }

    private static void copyFiles(Location loc1, Location loc2, File[] files) {
        if (files == null || files.length == 0) {
            return;
        }
        for (File f : files) {
            String fn = f.getName();
            IOX.copy((String)loc1.getPath(fn), (String)loc2.getPath(fn));
        }
    }

    private static Path findLocation(Path directory, String namebase) {
        if (!Files.exists(directory, new LinkOption[0])) {
            return null;
        }
        List<Path> maybe = DatabaseOpsWindows.scanForDirByPatternX(directory, namebase, SEP);
        return Util.getLastOrNull(maybe);
    }

    private static void checkSupportsAdmin(DatasetGraphSwitchable container) {
        if (!container.hasContainerPath()) {
            throw new TDBException("Dataset does not support admin operations");
        }
    }

    private static List<Path> scanForDirByPatternX(Path directory, String namebase, String nameSep) {
        Pattern pattern = Pattern.compile(Pattern.quote(namebase) + Pattern.quote(nameSep) + "[\\d]+");
        ArrayList<Path> paths = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory, namebase + "*");){
            for (Path entry : stream) {
                if (!pattern.matcher(entry.getFileName().toString()).matches()) {
                    throw new DBOpEnvException("Invalid filename for matching: " + String.valueOf(entry.getFileName()));
                }
                if (!Files.isDirectory(entry, new LinkOption[0])) {
                    throw new DBOpEnvException("Not a directory: " + String.valueOf(entry));
                }
                paths.add(entry);
            }
        }
        catch (IOException ex) {
            FmtLog.warn(IO_DB.class, (String)"Can't inspect directory: (%s, %s)", (Object[])new Object[]{directory, namebase});
            throw new DBOpEnvException((Throwable)ex);
        }
        Comparator comp = (f1, f2) -> {
            int num1 = DatabaseOpsWindows.extractIndexX(f1.getFileName().toString(), namebase, nameSep);
            int num2 = DatabaseOpsWindows.extractIndexX(f2.getFileName().toString(), namebase, nameSep);
            return Integer.compare(num1, num2);
        };
        paths.sort(comp);
        return paths;
    }

    private static int extractIndexX(String name, String namebase, String nameSep) {
        Matcher matcher = numberPattern.matcher(name);
        if (matcher.find()) {
            String numStr = matcher.group();
            int num = Integer.parseInt(numStr);
            return num;
        }
        throw new InternalErrorException("Expected to find a number in '" + name + "'");
    }
}

