/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.sparql.graph.PrefixMappingBase;

public final class PrefixMappingAdapter
extends PrefixMappingBase {
    private final PrefixMap prefixMap;

    public PrefixMappingAdapter(PrefixMap pmap) {
        this.prefixMap = pmap;
    }

    public PrefixMap getPrefixMap() {
        return this.prefixMap;
    }

    @Override
    protected void add(String prefix, String uri) {
        this.prefixMap.add(prefix, uri);
    }

    @Override
    protected void remove(String prefix) {
        this.prefixMap.delete(prefix);
    }

    @Override
    protected void clear() {
        this.prefixMap.clear();
    }

    @Override
    protected boolean isEmpty() {
        return this.prefixMap.isEmpty();
    }

    @Override
    protected int size() {
        return this.prefixMap.size();
    }

    @Override
    protected String prefixToUri(String prefix) {
        return this.prefixMap.getMapping().get(prefix);
    }

    @Override
    protected String uriToPrefix(String uri) {
        return this.prefixMap.getMapping().entrySet().stream().filter(e2 -> Objects.equals(uri, ((String)e2.getValue()).toString())).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    @Override
    protected Map<String, String> asMap() {
        return this.prefixMap.getMapping();
    }

    @Override
    protected Map<String, String> asMapCopy() {
        return this.prefixMap.getMappingCopy();
    }

    @Override
    protected void apply(BiConsumer<String, String> action) {
        this.prefixMap.forEach(action);
    }
}

