/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.consul;

import com.ecwid.consul.UrlParameters;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Utils {
    public static String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("So strange - every JVM has to support UTF-8 encoding.");
        }
    }

    public static String encodeUrl(String str) {
        try {
            URL url = new URL(str);
            URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            return uri.toASCIIString();
        }
        catch (Exception e) {
            throw new RuntimeException("Can't encode url", e);
        }
    }

    public static String generateUrl(String baseUrl, UrlParameters ... params) {
        return Utils.generateUrl(baseUrl, Arrays.asList(params));
    }

    public static String generateUrl(String baseUrl, List<UrlParameters> params) {
        if (params == null) {
            return baseUrl;
        }
        ArrayList<String> allParams = new ArrayList<String>();
        for (UrlParameters item : params) {
            if (item == null) continue;
            allParams.addAll(item.toUrlParameters());
        }
        StringBuilder result = new StringBuilder(baseUrl);
        Iterator paramsIterator = allParams.iterator();
        if (paramsIterator.hasNext()) {
            result.append("?").append((String)paramsIterator.next());
            while (paramsIterator.hasNext()) {
                result.append("&").append((String)paramsIterator.next());
            }
        }
        return result.toString();
    }

    public static String toUnsignedString(long l) {
        if (l >= 0L) {
            return Long.toString(l);
        }
        long quot = (l >>> 1) / 5L;
        long rem = l - quot * 10L;
        return Long.toString(quot) + rem;
    }

    public static long parseUnsignedLong(String s) {
        if (s.charAt(0) == '-') {
            throw new NumberFormatException("An unsigned long was expected. Cannot parse negative number " + s);
        }
        int length = s.length();
        if (length < 19) {
            return Long.parseLong(s);
        }
        long front = Long.parseLong(s.substring(0, length - 1));
        int onesDigit = Character.digit(s.charAt(length - 1), 10);
        if (onesDigit < 0) {
            throw new NumberFormatException("Invalid last digit for " + onesDigit);
        }
        long result = front * 10L + (long)onesDigit;
        if (Utils.compareLong(result + Long.MIN_VALUE, front + Long.MIN_VALUE) < 0) {
            throw new NumberFormatException("The number " + s + " is greater than 2^64");
        }
        return result;
    }

    private static int compareLong(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static String toSecondsString(long waitTime) {
        return String.valueOf(waitTime) + "s";
    }

    public static String assembleAgentAddress(String host, int port, String path) {
        String agentPath = "";
        if (path != null && !path.trim().isEmpty()) {
            agentPath = "/" + path;
        }
        return String.format("%s:%d%s", host, port, agentPath);
    }
}

