/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.cluster.raft.processor;

import com.alipay.sofa.jraft.rpc.RpcContext;
import com.alipay.sofa.jraft.rpc.RpcProcessor;
import org.apache.seata.common.metadata.Node;
import org.apache.seata.server.cluster.raft.RaftServer;
import org.apache.seata.server.cluster.raft.RaftServerManager;
import org.apache.seata.server.cluster.raft.RaftStateMachine;
import org.apache.seata.server.cluster.raft.processor.request.PutNodeMetadataRequest;
import org.apache.seata.server.cluster.raft.processor.response.PutNodeMetadataResponse;

public class PutNodeInfoRequestProcessor
implements RpcProcessor<PutNodeMetadataRequest> {
    public void handleRequest(RpcContext rpcCtx, PutNodeMetadataRequest request) {
        Node node = request.getNode();
        String group = node.getGroup();
        if (RaftServerManager.isLeader((String)group)) {
            RaftServer raftServer = RaftServerManager.getRaftServer((String)group);
            RaftStateMachine raftStateMachine = raftServer.getRaftStateMachine();
            raftStateMachine.changeNodeMetadata(node);
            rpcCtx.sendResponse((Object)new PutNodeMetadataResponse(true));
        } else {
            rpcCtx.sendResponse((Object)new PutNodeMetadataResponse(false));
        }
    }

    public String interest() {
        return PutNodeMetadataRequest.class.getName();
    }
}

