/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.cluster.manager;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.seata.common.rpc.http.HttpContext;
import org.apache.seata.common.thread.NamedThreadFactory;
import org.apache.seata.server.cluster.listener.ClusterChangeEvent;
import org.apache.seata.server.cluster.listener.ClusterChangeListener;
import org.apache.seata.server.cluster.watch.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ClusterWatcherManager
implements ClusterChangeListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Map<String, Queue<Watcher<HttpContext>>> WATCHERS = new ConcurrentHashMap();
    private static final Map<String, Long> GROUP_UPDATE_TERM = new ConcurrentHashMap();
    private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("long-polling", 1));

    @PostConstruct
    public void init() {
        this.scheduledThreadPoolExecutor.scheduleAtFixedRate(() -> {
            for (String group : WATCHERS.keySet()) {
                Optional.ofNullable((Queue)WATCHERS.remove(group)).ifPresent(watchers -> watchers.parallelStream().forEach(watcher -> {
                    if (System.currentTimeMillis() >= watcher.getTimeout()) {
                        watcher.setDone(true);
                        this.sendWatcherResponse(watcher, HttpResponseStatus.NOT_MODIFIED);
                    }
                    if (!watcher.isDone()) {
                        this.registryWatcher(watcher);
                    }
                }));
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    @EventListener
    @Async
    public void onChangeEvent(ClusterChangeEvent event) {
        if (event.getTerm() > 0L) {
            GROUP_UPDATE_TERM.put(event.getGroup(), event.getTerm());
            Optional.ofNullable((Queue)WATCHERS.remove(event.getGroup())).ifPresent(watchers -> watchers.parallelStream().forEach(arg_0 -> this.notifyWatcher(arg_0)));
        }
    }

    private void notifyWatcher(Watcher<HttpContext> watcher) {
        watcher.setDone(true);
        this.sendWatcherResponse(watcher, HttpResponseStatus.OK);
    }

    private void sendWatcherResponse(Watcher<HttpContext> watcher, HttpResponseStatus nettyStatus) {
        String group = watcher.getGroup();
        HttpContext context = (HttpContext)watcher.getAsyncContext();
        if (!(context instanceof HttpContext)) {
            this.logger.warn("Unsupported context type for watcher on group {}: {}", (Object)group, (Object)(context != null ? context.getClass().getName() : "null"));
            return;
        }
        ChannelHandlerContext ctx = context.getContext();
        if (!ctx.channel().isActive()) {
            this.logger.warn("Netty channel is not active for watcher on group {}, cannot send response.", (Object)group);
            return;
        }
        if (!context.isHttp2()) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, nettyStatus, Unpooled.EMPTY_BUFFER);
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
            if (!context.isKeepAlive()) {
                ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            } else {
                ctx.writeAndFlush((Object)response);
            }
        } else {
            Http2Headers headers = new DefaultHttp2Headers().status((CharSequence)nettyStatus.codeAsText());
            headers.set((Object)HttpHeaderNames.CONTENT_LENGTH, (Object)"0");
            ctx.write((Object)new DefaultHttp2HeadersFrame(headers));
            ctx.writeAndFlush((Object)new DefaultHttp2DataFrame(Unpooled.EMPTY_BUFFER, true)).addListener(f -> {
                if (!f.isSuccess()) {
                    this.logger.warn("HTTP2 response send failed, group={}", (Object)group, (Object)f.cause());
                }
            });
        }
    }

    public void registryWatcher(Watcher<HttpContext> watcher) {
        String group = watcher.getGroup();
        Long term = (Long)GROUP_UPDATE_TERM.get(group);
        if (term == null || watcher.getTerm() >= term) {
            WATCHERS.computeIfAbsent(group, value -> new ConcurrentLinkedQueue()).add(watcher);
        } else {
            this.notifyWatcher(watcher);
        }
    }
}

