/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.metrics;

import com.azure.core.implementation.util.Providers;
import com.azure.core.util.LibraryTelemetryOptions;
import com.azure.core.util.MetricsOptions;
import com.azure.core.util.TelemetryAttributes;
import com.azure.core.util.metrics.LongGauge;
import com.azure.core.util.metrics.Meter;
import com.azure.core.util.metrics.MeterProvider;
import com.azure.core.util.metrics.NoopMeter;
import java.util.Objects;
import java.util.function.Supplier;

final class DefaultMeterProvider
implements MeterProvider {
    private static final MeterProvider INSTANCE = new DefaultMeterProvider();
    private static final MetricsOptions DEFAULT_OPTIONS = new MetricsOptions();
    private static final AutoCloseable NOOP_CLOSEABLE = () -> {};
    private static final String NO_DEFAULT_PROVIDER = "A request was made to load the default MeterProvider provider but one could not be found on the classpath. If you are using a dependency manager, consider including a dependency on azure-core-metrics-opentelemetry or enabling instrumentation package.";
    private static final Providers<MeterProvider, Meter> METER_PROVIDER = new Providers(MeterProvider.class, null, "A request was made to load the default MeterProvider provider but one could not be found on the classpath. If you are using a dependency manager, consider including a dependency on azure-core-metrics-opentelemetry or enabling instrumentation package.");
    static final LongGauge NOOP_GAUGE = new LongGauge(){

        @Override
        public AutoCloseable registerCallback(Supplier<Long> valueSupplier, TelemetryAttributes attributes) {
            return NOOP_CLOSEABLE;
        }

        @Override
        public boolean isEnabled() {
            return false;
        }
    };

    private DefaultMeterProvider() {
    }

    static MeterProvider getInstance() {
        return INSTANCE;
    }

    @Override
    public Meter createMeter(String libraryName, String libraryVersion, MetricsOptions options) {
        Objects.requireNonNull(libraryName, "'libraryName' cannot be null.");
        LibraryTelemetryOptions sdkOptions = new LibraryTelemetryOptions(libraryName).setLibraryVersion(libraryVersion);
        return this.createMeter(sdkOptions, options);
    }

    @Override
    public Meter createMeter(LibraryTelemetryOptions libraryOptions, MetricsOptions applicationOptions) {
        Objects.requireNonNull(libraryOptions, "'libraryOptions' cannot be null.");
        MetricsOptions finalOptions = applicationOptions != null ? applicationOptions : DEFAULT_OPTIONS;
        return METER_PROVIDER.create(provider -> provider.createMeter(libraryOptions, finalOptions), NoopMeter.INSTANCE, finalOptions.getMeterProvider());
    }
}

