/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jdbc.internal;

import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.instrumentation.jdbc.internal.dbinfo.DbInfo;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public final class JdbcData {
    private static final Map<DbInfo, WeakReference<DbInfo>> dbInfos = new WeakHashMap<DbInfo, WeakReference<DbInfo>>();
    public static final VirtualField<Connection, DbInfo> connectionInfo = VirtualField.find(Connection.class, DbInfo.class);
    public static final VirtualField<PreparedStatement, String> preparedStatement = VirtualField.find(PreparedStatement.class, String.class);
    private static final VirtualField<Statement, StatementBatchInfo> statementBatch = VirtualField.find(Statement.class, StatementBatchInfo.class);
    private static final VirtualField<PreparedStatement, PreparedStatementBatchInfo> preparedStatementBatch = VirtualField.find(PreparedStatement.class, PreparedStatementBatchInfo.class);

    private JdbcData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbInfo intern(DbInfo dbInfo) {
        Map<DbInfo, WeakReference<DbInfo>> map = dbInfos;
        synchronized (map) {
            DbInfo result;
            WeakReference<DbInfo> reference = dbInfos.get(dbInfo);
            if (reference != null && (result = (DbInfo)reference.get()) != null) {
                return result;
            }
            dbInfos.put(dbInfo, new WeakReference<DbInfo>(dbInfo));
            return dbInfo;
        }
    }

    public static void addStatementBatch(Statement statement, String sql) {
        StatementBatchInfo batchInfo = (StatementBatchInfo)statementBatch.get((Object)statement);
        if (batchInfo == null) {
            batchInfo = new StatementBatchInfo();
            statementBatch.set((Object)statement, (Object)batchInfo);
        }
        batchInfo.add(sql);
    }

    public static void addPreparedStatementBatch(PreparedStatement statement) {
        PreparedStatementBatchInfo batchInfo = (PreparedStatementBatchInfo)preparedStatementBatch.get((Object)statement);
        if (batchInfo == null) {
            batchInfo = new PreparedStatementBatchInfo();
            preparedStatementBatch.set((Object)statement, (Object)batchInfo);
        }
        batchInfo.add();
    }

    public static void clearBatch(Statement statement) {
        if (statement instanceof PreparedStatement) {
            preparedStatementBatch.set((Object)((PreparedStatement)statement), null);
        } else {
            statementBatch.set((Object)statement, null);
        }
    }

    public static StatementBatchInfo getStatementBatchInfo(Statement statement) {
        return (StatementBatchInfo)statementBatch.get((Object)statement);
    }

    public static Long getPreparedStatementBatchSize(PreparedStatement statement) {
        PreparedStatementBatchInfo batchInfo = (PreparedStatementBatchInfo)preparedStatementBatch.get((Object)statement);
        return batchInfo != null ? Long.valueOf(batchInfo.getBatchSize()) : null;
    }

    public static final class StatementBatchInfo {
        private final List<String> statements = new ArrayList<String>();

        void add(String sql) {
            this.statements.add(sql);
        }

        public Collection<String> getStatements() {
            return this.statements;
        }

        public long getBatchSize() {
            return this.statements.size();
        }
    }

    private static final class PreparedStatementBatchInfo {
        private long batchSize;

        private PreparedStatementBatchInfo() {
        }

        void add() {
            ++this.batchSize;
        }

        long getBatchSize() {
            return this.batchSize;
        }
    }
}

