---
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
linkTitle: Security Report
type: docs
weight: 500
---

# Security Report

Adhering to the specifications of The ASF, the Apache Polaris community maintains a highly proactive and open attitude towards addressing security issues.

We strongly recommend that users first report such issues on the security@apache.org and private@polaris.apache.org, using the procedure details on [The ASF Security page](https://www.apache.org/security/committers.html).

Please note that the security@apache.org and private@polaris.apache.org mailing lists are reserved for reporting undisclosed security vulnerabilities and following the vulnerability resolution process.
Regular issue reports should be directed to GitHub Issue or the dev@polaris.apache.org mailing list.

The general process for handling security vulnerabilities as follows:

* The reporter privately reports the vulnerability to the security@apache.org and private@polaris.apache.org mailing lists (including as much information as possible, such as reproducible versions, relevant descriptions, reproduction methods, and the scope of impact).
* The Polaris PPMC collaborates privately with the reporter to discuss if the report is accepted, vulnerability resolution (after preliminary confirmation, a `CVE` can be requested).
* The podling creates a new release to include the vulnerability fix.
* At an appropriate date, a general description of the vulnerability and how to apply fix will be publicly disclosed (in compliance with The ASF standards) both on this page and on the dev@polaris.apache.org mailing list.

# Known Security Vulnerabilities (CVEs)

No CVE so far.
