/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth.internal;

import com.google.common.annotations.VisibleForTesting;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Set;
import org.apache.polaris.service.auth.AuthenticationRealmConfiguration;
import org.apache.polaris.service.auth.AuthenticationType;
import org.apache.polaris.service.auth.PolarisCredential;
import org.apache.polaris.service.auth.internal.InternalAuthenticationRequest;
import org.apache.polaris.service.auth.internal.broker.TokenBroker;

@ApplicationScoped
class InternalAuthenticationMechanism
implements HttpAuthenticationMechanism {
    public static final int PRIORITY = 1100;
    private static final String BEARER = "Bearer";
    @VisibleForTesting
    final AuthenticationRealmConfiguration configuration;
    private final TokenBroker tokenBroker;

    @Inject
    public InternalAuthenticationMechanism(AuthenticationRealmConfiguration configuration, TokenBroker tokenBroker) {
        this.configuration = configuration;
        this.tokenBroker = tokenBroker;
    }

    public int getPriority() {
        return 1100;
    }

    public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
        PolarisCredential token;
        if (this.configuration.type() == AuthenticationType.EXTERNAL) {
            return Uni.createFrom().nullItem();
        }
        String authHeader = context.request().getHeader("Authorization");
        if (authHeader == null) {
            return Uni.createFrom().nullItem();
        }
        int spaceIdx = authHeader.indexOf(32);
        if (spaceIdx <= 0 || !authHeader.substring(0, spaceIdx).equalsIgnoreCase(BEARER)) {
            return Uni.createFrom().nullItem();
        }
        String credential = authHeader.substring(spaceIdx + 1);
        try {
            token = this.tokenBroker.verify(credential);
        }
        catch (Exception e) {
            return this.configuration.type() == AuthenticationType.MIXED ? Uni.createFrom().nullItem() : Uni.createFrom().failure((Throwable)new AuthenticationFailedException((Throwable)e));
        }
        if (token == null) {
            return Uni.createFrom().nullItem();
        }
        return identityProviderManager.authenticate(HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)new InternalAuthenticationRequest(token), (RoutingContext)context));
    }

    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        ChallengeData result = new ChallengeData(HttpResponseStatus.UNAUTHORIZED.code(), (CharSequence)HttpHeaderNames.WWW_AUTHENTICATE, BEARER);
        return Uni.createFrom().item((Object)result);
    }

    public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
        return Collections.singleton(TokenAuthenticationRequest.class);
    }

    public Uni<HttpCredentialTransport> getCredentialTransport(RoutingContext context) {
        return Uni.createFrom().item((Object)new HttpCredentialTransport(HttpCredentialTransport.Type.AUTHORIZATION, BEARER));
    }

    public InternalAuthenticationMechanism() {
    }
}

