/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.memory;

import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStreamImpl;
import org.apache.ignite.internal.util.GridUnsafe;

public class PlatformBigEndianOutputStreamImpl
extends PlatformOutputStreamImpl {
    public PlatformBigEndianOutputStreamImpl(PlatformMemory mem) {
        super(mem);
    }

    @Override
    public void writeShort(short val) {
        super.writeShort(Short.reverseBytes(val));
    }

    @Override
    public void writeShortArray(short[] val) {
        int cnt = val.length << 1;
        this.ensureCapacity(this.pos + cnt);
        long startPos = this.data + (long)this.pos;
        for (short item : val) {
            GridUnsafe.putShort(startPos, Short.reverseBytes(item));
            startPos += 2L;
        }
        this.shift(cnt);
    }

    @Override
    public void writeChar(char val) {
        super.writeChar(Character.reverseBytes(val));
    }

    @Override
    public void writeCharArray(char[] val) {
        int cnt = val.length << 1;
        this.ensureCapacity(this.pos + cnt);
        long startPos = this.data + (long)this.pos;
        for (char item : val) {
            GridUnsafe.putChar(startPos, Character.reverseBytes(item));
            startPos += 2L;
        }
        this.shift(cnt);
    }

    @Override
    public void writeInt(int val) {
        super.writeInt(Integer.reverseBytes(val));
    }

    @Override
    public void writeIntArray(int[] val) {
        int cnt = val.length << 2;
        this.ensureCapacity(this.pos + cnt);
        long startPos = this.data + (long)this.pos;
        for (int item : val) {
            GridUnsafe.putInt(startPos, Integer.reverseBytes(item));
            startPos += 4L;
        }
        this.shift(cnt);
    }

    @Override
    public void writeShort(int pos, short val) {
        super.writeShort(pos, Short.reverseBytes(val));
    }

    @Override
    public void writeInt(int pos, int val) {
        super.writeInt(pos, Integer.reverseBytes(val));
    }

    @Override
    public void writeFloatArray(float[] val) {
        int cnt = val.length << 2;
        this.ensureCapacity(this.pos + cnt);
        long startPos = this.data + (long)this.pos;
        for (float item : val) {
            GridUnsafe.putInt(startPos, Integer.reverseBytes(Float.floatToIntBits(item)));
            startPos += 4L;
        }
        this.shift(cnt);
    }

    @Override
    public void writeLong(long val) {
        super.writeLong(Long.reverseBytes(val));
    }

    @Override
    public void writeLongArray(long[] val) {
        int cnt = val.length << 3;
        this.ensureCapacity(this.pos + cnt);
        long startPos = this.data + (long)this.pos;
        for (long item : val) {
            GridUnsafe.putLong(startPos, Long.reverseBytes(item));
            startPos += 8L;
        }
        this.shift(cnt);
    }

    @Override
    public void writeDoubleArray(double[] val) {
        int cnt = val.length << 3;
        this.ensureCapacity(this.pos + cnt);
        long startPos = this.data + (long)this.pos;
        for (double item : val) {
            GridUnsafe.putLong(startPos, Long.reverseBytes(Double.doubleToLongBits(item)));
            startPos += 8L;
        }
        this.shift(cnt);
    }

    @Override
    public void unsafeWriteShort(short val) {
        super.unsafeWriteShort(Short.reverseBytes(val));
    }

    @Override
    public void unsafeWriteShort(int pos, short val) {
        super.unsafeWriteShort(pos, Short.reverseBytes(val));
    }

    @Override
    public void unsafeWriteChar(char val) {
        super.unsafeWriteChar(Character.reverseBytes(val));
    }

    @Override
    public void unsafeWriteInt(int val) {
        super.unsafeWriteInt(Integer.reverseBytes(val));
    }

    @Override
    public void unsafeWriteInt(int pos, int val) {
        super.unsafeWriteInt(pos, Integer.reverseBytes(val));
    }

    @Override
    public void unsafeWriteLong(long val) {
        super.unsafeWriteLong(Long.reverseBytes(val));
    }
}

