/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.sql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.ignite3.internal.sql.engine.sql.IgniteDdlOperator;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlZoneOption;
import org.jetbrains.annotations.Nullable;

public class IgniteSqlCreateZone
extends SqlCreate {
    private static final String STORAGE_PROFILES_OPTION_NAME = "STORAGE_PROFILES";
    private static final Pattern STORAGE_PROFILES_SPLIT_PATTERN = Pattern.compile("\\s*,\\s*");
    private final SqlIdentifier name;
    private final SqlNodeList createOptionList;
    private final SqlNodeList storageProfiles;

    public static IgniteSqlCreateZone create(SqlParserPos pos, boolean ifNotExists, SqlIdentifier name, SqlNodeList createOptionList) {
        SqlNodeList profiles = SqlNodeList.of((SqlParserPos)pos, new ArrayList());
        Iterator optionsIt = createOptionList.iterator();
        while (optionsIt.hasNext()) {
            String[] profileNames;
            IgniteSqlZoneOption option = (IgniteSqlZoneOption)((Object)optionsIt.next());
            if (!option.key().getSimple().equals(STORAGE_PROFILES_OPTION_NAME)) continue;
            assert (option.value() instanceof SqlCharStringLiteral) : option.value();
            String profilesStr = (String)((SqlCharStringLiteral)option.value()).getValueAs(String.class);
            for (String profileName : profileNames = STORAGE_PROFILES_SPLIT_PATTERN.split(profilesStr)) {
                if (profileName.isBlank()) continue;
                profiles.add((SqlNode)SqlLiteral.createCharString((String)profileName, null, (SqlParserPos)option.getParserPosition()));
            }
            optionsIt.remove();
        }
        return new IgniteSqlCreateZone(pos, ifNotExists, name, createOptionList, profiles);
    }

    public IgniteSqlCreateZone(SqlParserPos pos, boolean ifNotExists, SqlIdentifier name, @Nullable SqlNodeList createOptionList, SqlNodeList storageProfiles) {
        super((SqlOperator)new Operator(ifNotExists), pos, false, ifNotExists);
        this.name = Objects.requireNonNull(name, "name");
        this.createOptionList = createOptionList != null ? createOptionList : SqlNodeList.of((SqlParserPos)pos, List.of());
        this.storageProfiles = Objects.requireNonNull(storageProfiles, "storageProfiles");
    }

    public IgniteDdlOperator getOperator() {
        return (IgniteDdlOperator)super.getOperator();
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name, (Object)this.createOptionList, (Object)this.storageProfiles);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame;
        writer.keyword("CREATE");
        writer.keyword("ZONE");
        if (this.ifNotExists()) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        if (!this.createOptionList.isEmpty()) {
            frame = writer.startList("(", ")");
            for (SqlNode c : this.createOptionList) {
                writer.sep(",");
                c.unparse(writer, 0, 0);
            }
            writer.endList(frame);
        }
        if (!this.storageProfiles.isEmpty()) {
            writer.keyword("STORAGE PROFILES");
            frame = writer.startList((SqlWriter.FrameType)SqlWriter.FrameTypeEnum.SIMPLE, "[", "]");
            for (SqlNode c : this.storageProfiles) {
                writer.sep(",");
                c.unparse(writer, 0, 0);
            }
            writer.endList(frame);
        }
    }

    public SqlIdentifier name() {
        return this.name;
    }

    public SqlNodeList createOptionList() {
        return this.createOptionList;
    }

    public SqlNodeList storageProfiles() {
        return this.storageProfiles;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    protected static class Operator
    extends IgniteDdlOperator {
        protected Operator(boolean existFlag) {
            super("CREATE ZONE", SqlKind.OTHER_DDL, existFlag);
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new IgniteSqlCreateZone(pos, this.existFlag(), (SqlIdentifier)operands[0], (SqlNodeList)operands[1], (SqlNodeList)operands[2]);
        }
    }
}

