/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.storage.NewSchemaEntry;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;

public class NewSchemaEntrySerializers {

    @CatalogSerializer(version=2, since="3.1.0")
    static class SerializerV2
    implements CatalogObjectSerializer<NewSchemaEntry> {
        SerializerV2() {
        }

        @Override
        public NewSchemaEntry readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogSchemaDescriptor schemaDescriptor = input.readEntry(CatalogSchemaDescriptor.class);
            return new NewSchemaEntry(schemaDescriptor);
        }

        @Override
        public void writeTo(NewSchemaEntry value, CatalogObjectDataOutput output) throws IOException {
            output.writeEntry(value.descriptor());
        }
    }

    @CatalogSerializer(version=1, since="3.0.0")
    static class SerializerV1
    implements CatalogObjectSerializer<NewSchemaEntry> {
        private final CatalogEntrySerializerProvider serializers;

        public SerializerV1(CatalogEntrySerializerProvider serializers) {
            this.serializers = serializers;
        }

        @Override
        public NewSchemaEntry readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogObjectSerializer serializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_SCHEMA.id());
            CatalogSchemaDescriptor schemaDescriptor = (CatalogSchemaDescriptor)serializer.readFrom(input);
            return new NewSchemaEntry(schemaDescriptor);
        }

        @Override
        public void writeTo(NewSchemaEntry value, CatalogObjectDataOutput output) throws IOException {
            this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_SCHEMA.id()).writeTo(value.descriptor(), output);
        }
    }
}

