/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Nameable;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.utils.URLUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class MetricOperationsImpl<T, L>
extends OperationSupport
implements Nameable<MetricOperationsImpl<T, L>> {
    public static final String METRIC_ENDPOINT_URL = "apis/metrics.k8s.io/v1beta1/";
    private final Class<L> apiTypeListClass;
    private final Class<T> apiTypeClass;
    private final String plural;
    private final String configuredNamespace;
    private final String configuredName;
    private final Map<String, String> configuredLabels;

    public MetricOperationsImpl(OkHttpClient client, Config config, String configuredName, String configuredNamespace, String plural, Map<String, String> configuredLabels, Class<T> apiTypeClass, Class<L> apiTypeListClass) {
        super(new OperationContext().withOkhttpClient(client).withConfig(config));
        this.plural = plural;
        this.apiTypeClass = apiTypeClass;
        this.apiTypeListClass = apiTypeListClass;
        this.configuredNamespace = configuredNamespace;
        this.configuredName = configuredName;
        this.configuredLabels = configuredLabels;
    }

    @Override
    public MetricOperationsImpl<T, L> withName(String name) {
        return new MetricOperationsImpl<T, L>(this.client, this.config, name, this.configuredNamespace, this.plural, this.configuredLabels, this.apiTypeClass, this.apiTypeListClass);
    }

    public MetricOperationsImpl<T, L> withLabels(Map<String, String> labels) {
        return new MetricOperationsImpl<T, L>(this.client, this.config, this.name, this.configuredNamespace, this.plural, labels, this.apiTypeClass, this.apiTypeListClass);
    }

    public L metrics() {
        try {
            return this.handleMetric(this.getMetricEndpointUrl(), this.apiTypeListClass);
        }
        catch (IOException | ExecutionException exception) {
            throw KubernetesClientException.launderThrowable(exception);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(interruptedException);
        }
    }

    public T metric() {
        try {
            return this.handleMetric(this.getMetricEndpointUrl(), this.apiTypeClass);
        }
        catch (IOException | ExecutionException exception) {
            throw KubernetesClientException.launderThrowable(exception);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(interruptedException);
        }
    }

    public L metrics(Map<String, Object> labelsMap) {
        HashMap<String, String> labels = new HashMap<String, String>();
        labelsMap.forEach((k, v) -> labels.put((String)k, v.toString()));
        return this.withLabels(labels).metrics();
    }

    protected String getMetricEndpointUrlWithPlural(String plural) {
        String result = URLUtils.join(this.config.getMasterUrl(), METRIC_ENDPOINT_URL);
        if (this.configuredNamespace != null) {
            result = result + "namespaces/" + this.configuredNamespace + "/";
        }
        result = result + plural;
        if (this.configuredName != null) {
            result = result + "/" + this.configuredName;
        }
        if (this.configuredLabels != null) {
            result = this.getUrlWithLabels(result, this.configuredLabels);
        }
        return result;
    }

    private String getMetricEndpointUrl() {
        return this.getMetricEndpointUrlWithPlural(this.plural);
    }

    private String getUrlWithLabels(String baseUrl, Map<String, String> labels) {
        HttpUrl.Builder httpUrlBuilder = HttpUrl.get(baseUrl).newBuilder();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append(",");
        }
        httpUrlBuilder.addQueryParameter("labelSelector", sb.substring(0, sb.toString().length() - 1));
        return httpUrlBuilder.toString();
    }
}

