/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.rest;

import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.config.JAXRSProviderManager;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import java.util.Set;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class SofaResteasyClientBuilder
extends ResteasyClientBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SofaResteasyClientBuilder.class);

    public SofaResteasyClientBuilder registerProvider() {
        Set<Object> customProviderInstances;
        ResteasyProviderFactory providerFactory = this.getProviderFactory();
        Set<Class> internalProviderClasses = JAXRSProviderManager.getInternalProviderClasses();
        if (CommonUtils.isNotEmpty(internalProviderClasses)) {
            for (Class providerClass : internalProviderClasses) {
                providerFactory.register(providerClass);
            }
        }
        if (CommonUtils.isNotEmpty(customProviderInstances = JAXRSProviderManager.getCustomProviderInstances())) {
            for (Object provider : customProviderInstances) {
                PropertyInjector propertyInjector = providerFactory.getInjectorFactory().createPropertyInjector(JAXRSProviderManager.getTargetClass(provider), providerFactory);
                propertyInjector.inject(provider);
                providerFactory.registerProviderInstance(provider);
            }
        }
        return this;
    }

    public SofaResteasyClientBuilder logProviders() {
        if (LOGGER.isDebugEnabled()) {
            Set pcs = this.getProviderFactory().getProviderClasses();
            StringBuilder sb = new StringBuilder();
            sb.append("\ndefault-providers:\n");
            for (Object provider : pcs) {
                sb.append("  ").append(provider).append("\n");
            }
            LOGGER.debug(sb.toString());
        }
        return this;
    }
}

