/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.async.methods;

import com.github.luben.zstd.ZstdDirectBufferCompressingStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.util.Args;

public final class DeflatingZstdEntityProducer
implements AsyncEntityProducer {
    private static final int IN_BUF = 65536;
    private static final int OUT_BUF_DEFAULT = 131072;
    private final AsyncEntityProducer delegate;
    private final ByteBuffer inDirect = ByteBuffer.allocateDirect(65536);
    private final Deque<ByteBuffer> pending = new ArrayDeque<ByteBuffer>();
    private ByteBuffer outBuf;
    private ZstdDirectBufferCompressingStream zstream;
    private volatile boolean upstreamEnded = false;
    private volatile boolean finished = false;
    private final AtomicBoolean released = new AtomicBoolean(false);
    private final int level;
    private final int outCap;

    public DeflatingZstdEntityProducer(AsyncEntityProducer delegate) {
        this(delegate, 3);
    }

    public DeflatingZstdEntityProducer(AsyncEntityProducer delegate, int level) {
        this.delegate = (AsyncEntityProducer)Args.notNull((Object)delegate, (String)"delegate");
        this.level = level;
        this.inDirect.limit(0);
        int rec = ZstdDirectBufferCompressingStream.recommendedOutputBufferSize();
        this.outCap = Math.max(131072, rec);
        this.outBuf = ByteBuffer.allocateDirect(this.outCap);
    }

    public boolean isRepeatable() {
        return this.delegate.isRepeatable();
    }

    public long getContentLength() {
        return -1L;
    }

    public String getContentType() {
        return this.delegate.getContentType();
    }

    public String getContentEncoding() {
        return "zstd";
    }

    public boolean isChunked() {
        return true;
    }

    public Set<String> getTrailerNames() {
        return Collections.emptySet();
    }

    public int available() {
        if (!this.pending.isEmpty()) {
            ByteBuffer head = this.pending.peekFirst();
            return head != null ? head.remaining() : 1;
        }
        if (this.upstreamEnded && !this.finished) {
            return 131072;
        }
        return this.delegate.available();
    }

    public void produce(DataStreamChannel chan) throws IOException {
        this.ensureStreamInitialized();
        if (!this.flushPending(chan)) {
            return;
        }
        if (this.finished) {
            return;
        }
        this.delegate.produce((DataStreamChannel)new Inner(chan));
        if (this.upstreamEnded && !this.finished) {
            this.zstream.close();
            if (!this.flushPending(chan)) {
                return;
            }
            this.finished = true;
            chan.endStream();
        }
    }

    private void ensureStreamInitialized() throws IOException {
        if (this.zstream != null) {
            return;
        }
        this.zstream = new ZstdDirectBufferCompressingStream(this.outBuf, this.level){

            protected ByteBuffer flushBuffer(ByteBuffer toFlush) throws IOException {
                toFlush.flip();
                if (toFlush.hasRemaining()) {
                    DeflatingZstdEntityProducer.this.pending.addLast(toFlush);
                }
                DeflatingZstdEntityProducer.this.outBuf = ByteBuffer.allocateDirect(DeflatingZstdEntityProducer.this.outCap);
                return DeflatingZstdEntityProducer.this.outBuf;
            }
        };
    }

    private boolean flushPending(DataStreamChannel chan) throws IOException {
        while (!this.pending.isEmpty()) {
            ByteBuffer head = this.pending.peekFirst();
            while (head.hasRemaining()) {
                int n = chan.write(head);
                if (n != 0) continue;
                chan.requestOutput();
                return false;
            }
            this.pending.removeFirst();
        }
        return true;
    }

    private int compressFrom(ByteBuffer src) throws IOException {
        int before = src.remaining();
        if (src.isDirect()) {
            this.zstream.compress(src);
        } else {
            while (src.hasRemaining()) {
                this.inDirect.compact();
                int take = Math.min(this.inDirect.remaining(), src.remaining());
                int oldLimit = src.limit();
                src.limit(src.position() + take);
                this.inDirect.put(src);
                src.limit(oldLimit);
                this.inDirect.flip();
                this.zstream.compress(this.inDirect);
            }
        }
        return before - src.remaining();
    }

    public void failed(Exception cause) {
        this.delegate.failed(cause);
    }

    public void releaseResources() {
        if (this.released.compareAndSet(false, true)) {
            try {
                try {
                    if (this.zstream != null) {
                        this.zstream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            finally {
                this.delegate.releaseResources();
            }
        }
    }

    private final class Inner
    implements DataStreamChannel {
        private final DataStreamChannel downstream;

        Inner(DataStreamChannel downstream) {
            this.downstream = downstream;
        }

        public void requestOutput() {
            this.downstream.requestOutput();
        }

        public int write(ByteBuffer src) throws IOException {
            int consumed = DeflatingZstdEntityProducer.this.compressFrom(src);
            if (!DeflatingZstdEntityProducer.this.flushPending(this.downstream)) {
                this.downstream.requestOutput();
            }
            return consumed;
        }

        public void endStream() {
            DeflatingZstdEntityProducer.this.upstreamEnded = true;
            this.downstream.requestOutput();
        }

        public void endStream(List<? extends Header> trailers) {
            this.endStream();
        }
    }
}

