/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.StoreDataManager;
import org.datanucleus.store.rdbms.AbstractSchemaTransaction;
import org.datanucleus.store.rdbms.RDBMSStoreData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.schema.RDBMSSchemaHandler;
import org.datanucleus.store.rdbms.table.ClassTable;
import org.datanucleus.store.rdbms.table.ClassView;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.rdbms.table.TableImpl;
import org.datanucleus.store.rdbms.table.ViewImpl;
import org.datanucleus.store.schema.StoreSchemaData;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class DeleteTablesSchemaTransaction
extends AbstractSchemaTransaction {
    StoreDataManager storeDataMgr = null;
    Writer writer;

    public DeleteTablesSchemaTransaction(RDBMSStoreManager rdbmsMgr, int isolationLevel, StoreDataManager dataMgr) {
        super(rdbmsMgr, isolationLevel);
        this.storeDataMgr = dataMgr;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run(ClassLoaderResolver clr) throws SQLException {
        RDBMSStoreManager rDBMSStoreManager = this.rdbmsMgr;
        synchronized (rDBMSStoreManager) {
            boolean success = true;
            try {
                TableImpl tbl;
                NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"050045", (Object[])new Object[]{this.rdbmsMgr.getDefaultCatalogName(), this.rdbmsMgr.getDefaultSchemaName()}));
                HashSet<Table> tables = new HashSet<Table>();
                HashSet<Table> views = new HashSet<Table>();
                for (RDBMSStoreData data : this.storeDataMgr.getManagedStoreData()) {
                    if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"050046", (Object[])new Object[]{data.getName()}));
                    }
                    if (!data.hasTable()) continue;
                    if (data.mapsToView()) {
                        views.add(data.getTable());
                        continue;
                    }
                    tables.add(data.getTable());
                }
                for (Table tblToDrop : views) {
                    StoreSchemaData info;
                    ViewImpl view = (ViewImpl)tblToDrop;
                    if (this.writer != null) {
                        try {
                            if (view instanceof ClassView) {
                                this.writer.write("-- ClassView " + view.toString() + " for classes " + StringUtils.objectArrayToString((Object[])((ClassView)view).getManagedClasses()) + "\n");
                            }
                        }
                        catch (IOException ioe) {
                            NucleusLogger.DATASTORE_SCHEMA.error((Object)"error writing DDL into file", (Throwable)ioe);
                        }
                    }
                    if ((info = this.rdbmsMgr.getSchemaHandler().getSchemaData((Object)this.getCurrentConnection(), "columns", new Object[]{view})) == null) continue;
                    view.drop(this.getCurrentConnection());
                }
                HashMap<TableImpl, Boolean> schemaExistsForTableMap = new HashMap<TableImpl, Boolean>();
                for (Table tblToDrop : tables) {
                    tbl = (TableImpl)tblToDrop;
                    if (this.writer != null) {
                        try {
                            if (tbl instanceof ClassTable) {
                                this.writer.write("-- Constraints for ClassTable " + tbl.toString() + " for classes " + StringUtils.objectArrayToString((Object[])((ClassTable)tbl).getManagedClasses()) + "\n");
                            } else if (tbl instanceof JoinTable) {
                                this.writer.write("-- Constraints for JoinTable " + tbl.toString() + " for join relationship\n");
                            }
                        }
                        catch (IOException ioe) {
                            NucleusLogger.DATASTORE_SCHEMA.error((Object)"error writing DDL into file", (Throwable)ioe);
                        }
                    }
                    boolean exists = false;
                    try {
                        String tableType = ((RDBMSSchemaHandler)this.rdbmsMgr.getSchemaHandler()).getTableType(this.getCurrentConnection(), tbl);
                        if (tableType != null) {
                            exists = true;
                        }
                    }
                    catch (Exception e) {
                        exists = false;
                    }
                    schemaExistsForTableMap.put(tbl, exists);
                    if (!exists) continue;
                    tbl.dropConstraints(this.getCurrentConnection());
                }
                for (Table tblToDrop : tables) {
                    Boolean schemaExists;
                    tbl = (TableImpl)tblToDrop;
                    if (this.writer != null) {
                        try {
                            if (tbl instanceof ClassTable) {
                                this.writer.write("-- ClassTable " + tbl.toString() + " for classes " + StringUtils.objectArrayToString((Object[])((ClassTable)tbl).getManagedClasses()) + "\n");
                            } else if (tbl instanceof JoinTable) {
                                this.writer.write("-- JoinTable " + tbl.toString() + " for join relationship\n");
                            }
                        }
                        catch (IOException ioe) {
                            NucleusLogger.DATASTORE_SCHEMA.error((Object)"error writing DDL into file", (Throwable)ioe);
                        }
                    }
                    if ((schemaExists = (Boolean)schemaExistsForTableMap.get(tbl)) == null || schemaExists != Boolean.TRUE) continue;
                    tbl.drop(this.getCurrentConnection());
                }
            }
            catch (Exception e) {
                success = false;
                String errorMsg = Localiser.msg((String)"050047", (Object[])new Object[]{e});
                NucleusLogger.DATASTORE_SCHEMA.error((Object)errorMsg);
                throw new NucleusUserException(errorMsg, (Throwable)e);
            }
            if (!success) {
                throw new NucleusException("DeleteTables operation failed");
            }
        }
    }

    @Override
    public String toString() {
        return Localiser.msg((String)"050045", (Object[])new Object[]{this.rdbmsMgr.getDefaultCatalogName(), this.rdbmsMgr.getDefaultSchemaName()});
    }
}

