/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelShuttle;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hadoop.hive.ql.plan.ColStatistics;

public class HiveTableScan
extends TableScan
implements HiveRelNode {
    private final RelDataType hiveTableScanRowType;
    private final ImmutableList<Integer> neededColIndxsFrmReloptHT;
    private final String tblAlias;
    private final String concatQbIDAlias;
    private final boolean useQBIdInDigest;
    private final ImmutableSet<Integer> virtualOrPartColIndxsInTS;
    private final ImmutableSet<Integer> virtualColIndxsInTS;
    private final boolean insideView;
    private final HiveTableScanTrait tableScanTrait;

    public String getTableAlias() {
        return this.tblAlias;
    }

    public String getConcatQbIDAlias() {
        return this.concatQbIDAlias;
    }

    public HiveTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptHiveTable table, String alias, String concatQbIDAlias, boolean useQBIdInDigest, boolean insideView) {
        this(cluster, traitSet, table, alias, concatQbIDAlias, table.getRowType(), useQBIdInDigest, insideView, null);
    }

    public HiveTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptHiveTable table, String alias, String concatQbIDAlias, boolean useQBIdInDigest, boolean insideView, HiveTableScanTrait tableScanTrait) {
        this(cluster, traitSet, table, alias, concatQbIDAlias, table.getRowType(), useQBIdInDigest, insideView, tableScanTrait);
    }

    private HiveTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptHiveTable table, String alias, String concatQbIDAlias, RelDataType newRowtype, boolean useQBIdInDigest, boolean insideView, HiveTableScanTrait tableScanTrait) {
        super(cluster, TraitsUtil.getDefaultTraitSet(cluster), (RelOptTable)table);
        assert (this.getTraitSet().containsIfApplicable((RelTrait)HiveRelNode.CONVENTION));
        this.tblAlias = alias;
        this.concatQbIDAlias = concatQbIDAlias;
        this.hiveTableScanRowType = newRowtype;
        Triple<ImmutableList<Integer>, ImmutableSet<Integer>, ImmutableSet<Integer>> colIndxPair = HiveTableScan.buildColIndxsFrmReloptHT(table, newRowtype);
        this.neededColIndxsFrmReloptHT = (ImmutableList)colIndxPair.getLeft();
        this.virtualOrPartColIndxsInTS = (ImmutableSet)colIndxPair.getMiddle();
        this.virtualColIndxsInTS = (ImmutableSet)colIndxPair.getRight();
        this.useQBIdInDigest = useQBIdInDigest;
        this.insideView = insideView;
        this.tableScanTrait = tableScanTrait;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return this;
    }

    public HiveTableScan copy(RelDataType newRowtype) {
        return new HiveTableScan(this.getCluster(), this.getTraitSet(), (RelOptHiveTable)this.table, this.tblAlias, this.concatQbIDAlias, newRowtype, this.useQBIdInDigest, this.insideView, this.tableScanTrait);
    }

    public HiveTableScan setTableScanTrait(HiveTableScanTrait tableScanTrait) {
        return new HiveTableScan(this.getCluster(), this.getTraitSet(), (RelOptHiveTable)this.table, this.tblAlias, this.concatQbIDAlias, this.rowType, this.useQBIdInDigest, this.insideView, tableScanTrait);
    }

    public HiveTableScan copyIncludingTable(RelDataType newRowtype) {
        return new HiveTableScan(this.getCluster(), this.getTraitSet(), ((RelOptHiveTable)this.table).copy(newRowtype), this.tblAlias, this.concatQbIDAlias, newRowtype, this.useQBIdInDigest, this.insideView, this.tableScanTrait);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("qbid:alias", (Object)this.concatQbIDAlias, this.useQBIdInDigest).itemIf("htColumns", this.neededColIndxsFrmReloptHT, pw.getDetailLevel() == SqlExplainLevel.DIGEST_ATTRIBUTES).itemIf("insideView", (Object)this.isInsideView(), pw.getDetailLevel() == SqlExplainLevel.DIGEST_ATTRIBUTES).itemIf("plKey", (Object)((RelOptHiveTable)this.table).getPartitionListKey(), pw.getDetailLevel() == SqlExplainLevel.DIGEST_ATTRIBUTES).itemIf("table:alias", (Object)this.tblAlias, !this.useQBIdInDigest).itemIf("tableScanTrait", (Object)this.tableScanTrait, pw.getDetailLevel() == SqlExplainLevel.DIGEST_ATTRIBUTES).itemIf("fromVersion", (Object)((RelOptHiveTable)this.table).getHiveTableMD().getVersionIntervalFrom(), StringUtils.isNotBlank((CharSequence)((RelOptHiveTable)this.table).getHiveTableMD().getVersionIntervalFrom()));
    }

    public void register(RelOptPlanner planner) {
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        return ((RelOptHiveTable)this.table).getRowCount();
    }

    public List<ColStatistics> getColStat(List<Integer> projIndxLst) {
        return ((RelOptHiveTable)this.table).getColStat(projIndxLst);
    }

    public RelNode project(ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields, RelBuilder relBuilder) {
        int fieldCount = this.getRowType().getFieldCount();
        if (fieldsUsed.equals((Object)ImmutableBitSet.range((int)fieldCount)) && extraFields.isEmpty()) {
            return this;
        }
        if (extraFields != null && !extraFields.isEmpty()) {
            throw new RuntimeException("Hive TS does not support adding virtual columns dynamically");
        }
        List fields = this.getRowType().getFieldList();
        LinkedList<RelDataType> fieldTypes = new LinkedList<RelDataType>();
        LinkedList<String> fieldNames = new LinkedList<String>();
        ArrayList<RexInputRef> exprList = new ArrayList<RexInputRef>();
        RexBuilder rexBuilder = this.getCluster().getRexBuilder();
        Iterator iterator = fieldsUsed.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            RelDataTypeField field = (RelDataTypeField)fields.get(i);
            fieldTypes.add(field.getType());
            fieldNames.add(field.getName());
            exprList.add(rexBuilder.makeInputRef((RelNode)this, i));
        }
        HiveTableScan newHT = this.copy(this.getCluster().getTypeFactory().createStructType(fieldTypes, fieldNames));
        HiveProject hp = (HiveProject)relBuilder.push((RelNode)newHT).project(exprList, new ArrayList(fieldNames)).build();
        hp.setSynthetic();
        return hp;
    }

    public List<Integer> getNeededColIndxsFrmReloptHT() {
        return this.neededColIndxsFrmReloptHT;
    }

    public RelDataType getPrunedRowType() {
        return this.hiveTableScanRowType;
    }

    public Set<Integer> getPartOrVirtualCols() {
        return this.virtualOrPartColIndxsInTS;
    }

    public Set<Integer> getVirtualCols() {
        return this.virtualColIndxsInTS;
    }

    private static Triple<ImmutableList<Integer>, ImmutableSet<Integer>, ImmutableSet<Integer>> buildColIndxsFrmReloptHT(RelOptHiveTable relOptHTable, RelDataType scanRowType) {
        RelDataType relOptHtRowtype = relOptHTable.getRowType();
        ImmutableList.Builder neededColIndxsFrmReloptHTBldr = new ImmutableList.Builder();
        ImmutableSet.Builder virtualOrPartColIndxsInTSBldr = new ImmutableSet.Builder();
        ImmutableSet.Builder virtualColIndxsInTSBldr = new ImmutableSet.Builder();
        ImmutableMap<String, Integer> colNameToPosInReloptHT = HiveCalciteUtil.getRowColNameIndxMap(relOptHtRowtype.getFieldList());
        List colNamesInScanRowType = scanRowType.getFieldNames();
        int partColStartPosInrelOptHtRowtype = relOptHTable.getNonPartColumns().size();
        int virtualColStartPosInrelOptHtRowtype = relOptHTable.getNonPartColumns().size() + relOptHTable.getPartColumns().size();
        for (int i = 0; i < colNamesInScanRowType.size(); ++i) {
            int tmp = (Integer)colNameToPosInReloptHT.get(colNamesInScanRowType.get(i));
            neededColIndxsFrmReloptHTBldr.add((Object)tmp);
            if (tmp < partColStartPosInrelOptHtRowtype) continue;
            virtualOrPartColIndxsInTSBldr.add((Object)i);
            if (tmp < virtualColStartPosInrelOptHtRowtype) continue;
            virtualColIndxsInTSBldr.add((Object)i);
        }
        return Triple.of((Object)neededColIndxsFrmReloptHTBldr.build(), (Object)virtualOrPartColIndxsInTSBldr.build(), (Object)virtualColIndxsInTSBldr.build());
    }

    public boolean isInsideView() {
        return this.insideView;
    }

    public HiveTableScanTrait getTableScanTrait() {
        return this.tableScanTrait;
    }

    public RelNode accept(RelShuttle shuttle) {
        if (shuttle instanceof HiveRelShuttle) {
            return ((HiveRelShuttle)shuttle).visit(this);
        }
        return shuttle.visit((TableScan)this);
    }

    public static enum HiveTableScanTrait {
        FetchDeletedRows("acid.fetch.deleted.rows"),
        FetchInsertOnlyBucketIds("insertonly.fetch.bucketid");

        private final String propertyKey;

        private HiveTableScanTrait(String propertyKey) {
            this.propertyKey = propertyKey;
        }

        public String getPropertyKey() {
            return this.propertyKey;
        }

        public static HiveTableScanTrait from(Map<String, String> properties) {
            if (properties == null) {
                return null;
            }
            for (HiveTableScanTrait trait : HiveTableScanTrait.values()) {
                if (!Boolean.parseBoolean(properties.get(trait.propertyKey))) continue;
                return trait;
            }
            return null;
        }
    }
}

