/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class VectorPTFEvaluatorDecimalMin
extends VectorPTFEvaluatorBase {
    protected boolean isGroupResultNull;
    protected HiveDecimalWritable min = new HiveDecimalWritable();

    public VectorPTFEvaluatorDecimalMin(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch) throws HiveException {
        block14: {
            DecimalColumnVector decimalColVector;
            int size;
            block13: {
                block15: {
                    this.evaluateInputExpr(batch);
                    Preconditions.checkState((!batch.selectedInUse ? 1 : 0) != 0);
                    size = batch.size;
                    if (size == 0) {
                        return;
                    }
                    decimalColVector = (DecimalColumnVector)batch.cols[this.inputColumnNum];
                    if (!decimalColVector.isRepeating) break block13;
                    if (!decimalColVector.noNulls && decimalColVector.isNull[0]) break block14;
                    if (!this.isGroupResultNull) break block15;
                    this.min.set(decimalColVector.vector[0]);
                    this.isGroupResultNull = false;
                    break block14;
                }
                HiveDecimalWritable repeatedMin = decimalColVector.vector[0];
                if (repeatedMin.compareTo(this.min) != -1) break block14;
                this.min.set(repeatedMin);
                break block14;
            }
            if (decimalColVector.noNulls) {
                HiveDecimalWritable[] vector = decimalColVector.vector;
                if (this.isGroupResultNull) {
                    this.min.set(vector[0]);
                    this.isGroupResultNull = false;
                } else {
                    HiveDecimalWritable dec = vector[0];
                    if (dec.compareTo(this.min) == -1) {
                        this.min.set(dec);
                    }
                }
                for (int i = 1; i < size; ++i) {
                    HiveDecimalWritable dec = vector[i];
                    if (dec.compareTo(this.min) != -1) continue;
                    this.min.set(dec);
                }
            } else {
                boolean[] batchIsNull = decimalColVector.isNull;
                int i = 0;
                while (batchIsNull[i]) {
                    if (++i < size) continue;
                    return;
                }
                HiveDecimalWritable[] vector = decimalColVector.vector;
                HiveDecimalWritable firstValue = vector[i++];
                if (this.isGroupResultNull) {
                    this.min.set(firstValue);
                    this.isGroupResultNull = false;
                } else if (firstValue.compareTo(this.min) == -1) {
                    this.min.set(firstValue);
                }
                while (i < size) {
                    HiveDecimalWritable dec;
                    if (!batchIsNull[i] && (dec = vector[i]).compareTo(this.min) == -1) {
                        this.min.set(dec);
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public boolean streamsResult() {
        return false;
    }

    @Override
    public boolean isGroupResultNull() {
        return this.isGroupResultNull;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.DECIMAL;
    }

    @Override
    public Object getGroupResult() {
        return this.min;
    }

    @Override
    public void resetEvaluator() {
        this.isGroupResultNull = true;
        this.min.setFromLong(0L);
    }
}

