/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.QueryInfo;
import org.apache.hadoop.hive.ql.log.LogDivertAppender;
import org.apache.hadoop.hive.ql.log.LogDivertAppenderForTest;
import org.apache.hadoop.hive.ql.session.OperationLog;
import org.apache.hive.service.AbstractService;
import org.apache.hive.service.Service;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationStatus;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.RowSetFactory;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.ExecuteStatementOperation;
import org.apache.hive.service.cli.operation.GetCatalogsOperation;
import org.apache.hive.service.cli.operation.GetColumnsOperation;
import org.apache.hive.service.cli.operation.GetCrossReferenceOperation;
import org.apache.hive.service.cli.operation.GetFunctionsOperation;
import org.apache.hive.service.cli.operation.GetPrimaryKeysOperation;
import org.apache.hive.service.cli.operation.GetSchemasOperation;
import org.apache.hive.service.cli.operation.GetTableTypesOperation;
import org.apache.hive.service.cli.operation.GetTablesOperation;
import org.apache.hive.service.cli.operation.GetTypeInfoOperation;
import org.apache.hive.service.cli.operation.MetadataOperation;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.operation.QueryInfoCache;
import org.apache.hive.service.cli.operation.SQLOperation;
import org.apache.hive.service.cli.session.HiveSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationManager
extends AbstractService {
    private final Logger LOG = LoggerFactory.getLogger((String)OperationManager.class.getName());
    private final ConcurrentHashMap<OperationHandle, Operation> handleToOperation = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Operation> queryIdOperation = new ConcurrentHashMap();
    private final SetMultimap<String, String> queryTagToIdMap = Multimaps.synchronizedSetMultimap((SetMultimap)MultimapBuilder.hashKeys().hashSetValues().build());
    private Optional<QueryInfoCache> queryInfoCache = Optional.empty();

    public OperationManager() {
        super(OperationManager.class.getSimpleName());
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        LogDivertAppender.registerRoutingAppender((Configuration)hiveConf);
        LogDivertAppenderForTest.registerRoutingAppenderIfInTest((Configuration)hiveConf);
        if (hiveConf.isWebUiEnabled()) {
            this.queryInfoCache = Optional.of(new QueryInfoCache(hiveConf));
        }
        super.init(hiveConf);
    }

    @Override
    public synchronized void start() {
        super.start();
    }

    @Override
    public synchronized void stop() {
        super.stop();
        for (Operation operation : this.getOperations()) {
            try {
                this.cancelOperation(operation.getHandle(), "Operation canceled due to HiveServer2 stop");
            }
            catch (Exception e) {
                this.LOG.warn("Error canceling the operation", (Throwable)e);
            }
        }
    }

    public ExecuteStatementOperation newExecuteStatementOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay, boolean runAsync, long queryTimeout) throws HiveSQLException {
        ExecuteStatementOperation executeStatementOperation = ExecuteStatementOperation.newExecuteStatementOperation(parentSession, statement, confOverlay, runAsync, queryTimeout);
        this.addOperation(executeStatementOperation);
        return executeStatementOperation;
    }

    public GetTypeInfoOperation newGetTypeInfoOperation(HiveSession parentSession) throws HiveSQLException {
        GetTypeInfoOperation operation = new GetTypeInfoOperation(parentSession);
        this.addOperation(operation);
        return operation;
    }

    public GetCatalogsOperation newGetCatalogsOperation(HiveSession parentSession) throws HiveSQLException {
        GetCatalogsOperation operation = new GetCatalogsOperation(parentSession);
        this.addOperation(operation);
        return operation;
    }

    public GetSchemasOperation newGetSchemasOperation(HiveSession parentSession, String catalogName, String schemaName) throws HiveSQLException {
        GetSchemasOperation operation = new GetSchemasOperation(parentSession, catalogName, schemaName);
        this.addOperation(operation);
        return operation;
    }

    public MetadataOperation newGetTablesOperation(HiveSession parentSession, String catalogName, String schemaName, String tableName, List<String> tableTypes) throws HiveSQLException {
        GetTablesOperation operation = new GetTablesOperation(parentSession, catalogName, schemaName, tableName, tableTypes);
        this.addOperation(operation);
        return operation;
    }

    public GetTableTypesOperation newGetTableTypesOperation(HiveSession parentSession) throws HiveSQLException {
        GetTableTypesOperation operation = new GetTableTypesOperation(parentSession);
        this.addOperation(operation);
        return operation;
    }

    public GetColumnsOperation newGetColumnsOperation(HiveSession parentSession, String catalogName, String schemaName, String tableName, String columnName) throws HiveSQLException {
        GetColumnsOperation operation = new GetColumnsOperation(parentSession, catalogName, schemaName, tableName, columnName);
        this.addOperation(operation);
        return operation;
    }

    public GetFunctionsOperation newGetFunctionsOperation(HiveSession parentSession, String catalogName, String schemaName, String functionName) throws HiveSQLException {
        GetFunctionsOperation operation = new GetFunctionsOperation(parentSession, catalogName, schemaName, functionName);
        this.addOperation(operation);
        return operation;
    }

    public GetPrimaryKeysOperation newGetPrimaryKeysOperation(HiveSession parentSession, String catalogName, String schemaName, String tableName) throws HiveSQLException {
        GetPrimaryKeysOperation operation = new GetPrimaryKeysOperation(parentSession, catalogName, schemaName, tableName);
        this.addOperation(operation);
        return operation;
    }

    public GetCrossReferenceOperation newGetCrossReferenceOperation(HiveSession session, String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws HiveSQLException {
        GetCrossReferenceOperation operation = new GetCrossReferenceOperation(session, primaryCatalog, primarySchema, primaryTable, foreignCatalog, foreignSchema, foreignTable);
        this.addOperation(operation);
        return operation;
    }

    public Operation newUploadDataOperation(HiveSession parentSession, ByteBuffer values, String tableName, String path) throws HiveSQLException {
        throw new HiveSQLException("unimplemented exception");
    }

    public Operation newDownloadDataOperation(HiveSession parentSession, String tableName, String query, String format, Map<String, String> options) throws HiveSQLException {
        throw new HiveSQLException("unimplemented exception");
    }

    public Operation getOperation(OperationHandle operationHandle) throws HiveSQLException {
        Operation operation = this.getOperationInternal(operationHandle);
        if (operation == null) {
            throw new HiveSQLException("Invalid OperationHandle: " + String.valueOf(operationHandle));
        }
        return operation;
    }

    private Operation getOperationInternal(OperationHandle operationHandle) {
        return this.handleToOperation.get(operationHandle);
    }

    private String getQueryId(Operation operation) {
        return operation.getQueryId();
    }

    private void addOperation(Operation operation) throws HiveSQLException {
        if (this.getServiceState() != Service.STATE.STARTED) {
            throw new HiveSQLException("Unable to run new queries as HiveServer2 is decommissioned or inactive, state: " + String.valueOf((Object)this.getServiceState()));
        }
        this.LOG.info("Adding operation: {} {}", (Object)operation.getHandle(), (Object)operation.getParentSession().getSessionHandle());
        this.queryIdOperation.put(this.getQueryId(operation), operation);
        this.handleToOperation.put(operation.getHandle(), operation);
        this.queryInfoCache.ifPresent(cache -> cache.addLiveQueryInfo(operation));
    }

    public void updateQueryTag(String queryId, String queryTag) {
        Operation operation = this.queryIdOperation.get(queryId);
        if (operation != null) {
            this.queryTagToIdMap.put((Object)queryTag, (Object)queryId);
            return;
        }
        this.LOG.info("Query id is missing during query tag updation");
    }

    private Operation removeOperation(OperationHandle opHandle) {
        Operation operation = this.handleToOperation.remove(opHandle);
        if (operation == null) {
            throw new RuntimeException("Operation does not exist: " + String.valueOf(opHandle));
        }
        String queryId = this.getQueryId(operation);
        this.queryIdOperation.remove(queryId);
        String queryTag = operation.getQueryTag();
        if (queryTag != null) {
            this.queryTagToIdMap.remove((Object)queryTag, (Object)queryId);
        }
        this.LOG.info("Removed queryId: {} corresponding to operation: {} with tag: {}", new Object[]{queryId, opHandle, queryTag});
        this.queryInfoCache.ifPresent(cache -> cache.removeLiveQueryInfo(operation));
        return operation;
    }

    private Operation removeTimedOutOperation(OperationHandle operationHandle) {
        Operation operation = this.handleToOperation.get(operationHandle);
        if (operation != null && operation.isTimedOut(System.currentTimeMillis())) {
            this.LOG.info("Operation is timed out,operation=" + String.valueOf(operation.getHandle()) + ",state=" + operation.getState().toString());
            Metrics metrics = MetricsFactory.getInstance();
            if (metrics != null) {
                try {
                    metrics.decrementCounter("open_operations");
                }
                catch (Exception e) {
                    this.LOG.warn("Error decrementing open_operations metric, reported values may be incorrect", (Throwable)e);
                }
            }
            return this.removeOperation(operationHandle);
        }
        return null;
    }

    public OperationStatus getOperationStatus(OperationHandle opHandle) throws HiveSQLException {
        return this.getOperation(opHandle).getStatus();
    }

    public void cancelOperation(OperationHandle opHandle, String errMsg) throws HiveSQLException {
        Operation operation = this.getOperation(opHandle);
        OperationState opState = operation.getState();
        if (opState.isTerminal()) {
            this.LOG.debug(String.valueOf(opHandle) + ": Operation is already aborted in state - " + String.valueOf((Object)opState));
        } else {
            this.LOG.debug(String.valueOf(opHandle) + ": Attempting to cancel from state - " + String.valueOf((Object)opState));
            OperationState operationState = OperationState.CANCELED;
            operationState.setErrorMessage(errMsg);
            operation.cancel(operationState);
            this.queryInfoCache.ifPresent(cache -> cache.removeLiveQueryInfo(operation));
        }
    }

    public void cancelOperation(OperationHandle opHandle) throws HiveSQLException {
        this.cancelOperation(opHandle, "");
    }

    public void closeOperation(OperationHandle opHandle) throws HiveSQLException {
        this.LOG.info("Closing operation: " + String.valueOf(opHandle));
        Operation operation = this.removeOperation(opHandle);
        Metrics metrics = MetricsFactory.getInstance();
        if (metrics != null) {
            try {
                metrics.decrementCounter("open_operations");
            }
            catch (Exception e) {
                this.LOG.warn("Error Reporting close operation to Metrics system", (Throwable)e);
            }
        }
        operation.close();
    }

    public TableSchema getOperationResultSetSchema(OperationHandle opHandle) throws HiveSQLException {
        return this.getOperation(opHandle).getResultSetSchema();
    }

    public RowSet getOperationNextRowSet(OperationHandle opHandle, FetchOrientation orientation, long maxRows) throws HiveSQLException {
        return this.getOperation(opHandle).getNextRowSet(orientation, maxRows);
    }

    public RowSet getOperationLogRowSet(OperationHandle opHandle, FetchOrientation orientation, long maxRows, HiveConf hConf) throws HiveSQLException {
        List logs;
        TableSchema tableSchema = new TableSchema(this.getLogSchema());
        RowSet rowSet = RowSetFactory.create(tableSchema, this.getOperation(opHandle).getProtocolVersion(), false);
        if (!hConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_ENABLED)) {
            this.LOG.warn("Try to get operation log when hive.server2.logging.operation.enabled is false, no log will be returned. ");
            return rowSet;
        }
        OperationLog operationLog = this.getOperation(opHandle).getOperationLog();
        if (operationLog == null) {
            throw new HiveSQLException("Couldn't find log associated with operation handle: " + String.valueOf(opHandle));
        }
        try {
            logs = operationLog.readOperationLog(this.isFetchFirst(orientation), maxRows);
        }
        catch (SQLException e) {
            throw new HiveSQLException(e.getMessage(), e.getCause());
        }
        for (String log : logs) {
            rowSet.addRow(new String[]{log});
        }
        return rowSet;
    }

    private boolean isFetchFirst(FetchOrientation fetchOrientation) {
        return fetchOrientation.equals((Object)FetchOrientation.FETCH_FIRST);
    }

    private Schema getLogSchema() {
        Schema schema = new Schema();
        FieldSchema fieldSchema = new FieldSchema();
        fieldSchema.setName("operation_log");
        fieldSchema.setType("string");
        schema.addToFieldSchemas(fieldSchema);
        return schema;
    }

    public Collection<Operation> getOperations() {
        return Collections.unmodifiableCollection(this.handleToOperation.values());
    }

    public List<Operation> removeExpiredOperations(OperationHandle[] handles) {
        ArrayList<Operation> removed = new ArrayList<Operation>();
        for (OperationHandle handle : handles) {
            Operation operation = this.removeTimedOutOperation(handle);
            if (operation == null) continue;
            this.LOG.warn("Operation " + String.valueOf(handle) + " is timed-out and will be closed");
            removed.add(operation);
        }
        return removed;
    }

    public List<QueryInfo> getHistoricalQueryInfos() {
        return this.queryInfoCache.map(cache -> cache.getHistoricalQueryInfos()).orElse(Collections.emptyList());
    }

    public List<QueryInfo> getLiveQueryInfos() {
        return this.queryInfoCache.map(cache -> cache.getLiveQueryInfos()).orElse(Collections.emptyList());
    }

    public QueryInfo getQueryInfo(String handle) {
        return this.queryInfoCache.map(cache -> cache.getQueryInfo(handle)).orElse(null);
    }

    public Operation getOperationByQueryId(String queryId) {
        return this.queryIdOperation.get(queryId);
    }

    public Set<Operation> getOperationsByQueryTag(String queryTag) {
        Set queryIds = this.queryTagToIdMap.get((Object)queryTag);
        HashSet<Operation> result = new HashSet<Operation>();
        for (String queryId : queryIds) {
            if (queryId == null || this.getOperationByQueryId(queryId) == null) continue;
            result.add(this.getOperationByQueryId(queryId));
        }
        return result;
    }

    public boolean canShowDrilldownLink(OperationHandle operationHandle) {
        try {
            if (!this.getHiveConf().isWebUiEnabled()) {
                return false;
            }
            Operation operation = this.getOperation(operationHandle);
            if (operation instanceof SQLOperation) {
                HiveConf hiveConf = ((SQLOperation)operation).queryState.getConf();
                return hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_SHOW_OPERATION_DRILLDOWN_LINK);
            }
        }
        catch (HiveSQLException hiveSQLException) {
            // empty catch block
        }
        return false;
    }

    public Set<String> getAllCachedQueryIds() {
        return this.queryInfoCache.map(cache -> cache.getAllQueryIds()).orElse(Collections.emptySet());
    }
}

