/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.util.TreeSet;
import javax.annotation.concurrent.GuardedBy;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RequestTracker {
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private long nextSeqNo = 1L;
    @GuardedBy(value="lock")
    private final TreeSet<Long> incompleteRpcs = new TreeSet();
    static final long NO_SEQ_NO = -1L;
    private final String clientId;

    public RequestTracker(String clientId) {
        this.clientId = clientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long newSeqNo() {
        Object object = this.lock;
        synchronized (object) {
            long seq = this.nextSeqNo++;
            this.incompleteRpcs.add(seq);
            return seq;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long firstIncomplete() {
        Object object = this.lock;
        synchronized (object) {
            if (this.incompleteRpcs.isEmpty()) {
                return -1L;
            }
            return this.incompleteRpcs.first();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rpcCompleted(long sequenceId) {
        assert (sequenceId != -1L);
        Object object = this.lock;
        synchronized (object) {
            boolean removed = this.incompleteRpcs.remove(sequenceId);
            assert (removed) : "Could not remove seqid " + sequenceId + " from request tracker";
        }
    }

    public String getClientId() {
        return this.clientId;
    }
}

