/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.geometric;

import com.xugu.cloudjdbc.Error;
import com.xugu.common.ReplaceEnum;
import com.xugu.geometric.DBlseg;
import com.xugu.geometric.DBpoint;
import com.xugu.util.DBobject;
import com.xugu.util.DBtokenizer;
import java.io.Serializable;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DBline
extends DBobject
implements Serializable,
Cloneable {
    public double a;
    public double b;
    public double c;
    private boolean isNull;

    public DBline(double a, double b, double c) {
        this();
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public DBline(double x1, double y1, double x2, double y2) {
        this();
        this.setValue(x1, y1, x2, y2);
    }

    public DBline(@Nullable DBpoint p1, @Nullable DBpoint p2) {
        this();
        this.setValue(p1, p2);
    }

    public DBline(@Nullable DBlseg lseg) {
        this();
        if (lseg == null) {
            this.isNull = true;
            return;
        }
        DBpoint[] point = lseg.point;
        if (point == null) {
            this.isNull = true;
            return;
        }
        this.setValue(point[0], point[1]);
    }

    private void setValue(@Nullable DBpoint p1, @Nullable DBpoint p2) {
        if (p1 == null || p2 == null) {
            this.isNull = true;
        } else {
            this.setValue(p1.x, p1.y, p2.x, p2.y);
        }
    }

    private void setValue(double x1, double y1, double x2, double y2) {
        if (x1 == x2) {
            this.a = -1.0;
            this.b = 0.0;
        } else {
            this.a = (y2 - y1) / (x2 - x1);
            this.b = -1.0;
        }
        this.c = y1 - this.a * x1;
    }

    public DBline(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public DBline() {
        this.type = "line";
    }

    @Override
    public void setValue(@Nullable String s) throws SQLException {
        boolean bl = this.isNull = s == null;
        if (s == null) {
            return;
        }
        if (s.trim().startsWith("{")) {
            DBtokenizer t = new DBtokenizer(DBtokenizer.removeCurlyBrace(s), ',');
            if (t.getSize() != 3) {
                throw Error.createSQLException("[E50044]Callable: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
            }
            this.a = Double.parseDouble(t.getToken(0));
            this.b = Double.parseDouble(t.getToken(1));
            this.c = Double.parseDouble(t.getToken(2));
        } else if (s.trim().startsWith("[")) {
            DBtokenizer t = new DBtokenizer(DBtokenizer.removeBox(s), ',');
            if (t.getSize() != 2) {
                throw Error.createSQLException("[E50044]Callable: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
            }
            DBpoint point1 = new DBpoint(t.getToken(0));
            DBpoint point2 = new DBpoint(t.getToken(1));
            this.a = point2.x - point1.x;
            this.b = point2.y - point1.y;
            this.c = point1.y;
        }
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DBline DBline2 = (DBline)obj;
        if (this.isNull) {
            return DBline2.isNull;
        }
        if (DBline2.isNull) {
            return false;
        }
        return Double.compare(DBline2.a, this.a) == 0 && Double.compare(DBline2.b, this.b) == 0 && Double.compare(DBline2.c, this.c) == 0;
    }

    @Override
    public int hashCode() {
        if (this.isNull) {
            return 0;
        }
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.a);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.b);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.c);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public @Nullable String getValue() {
        return this.isNull ? null : "{" + this.a + "," + this.b + "," + this.c + "}";
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

