/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.codegen.fields;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.plc4x.java.spi.codegen.FieldCommons;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithReaderWriterArgs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldReaderArray<T>
implements FieldCommons {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldReaderArray.class);

    public List<T> readFieldCount(String logicalName, DataReader<T> dataReader, long count, WithReaderArgs ... readerArgs) throws ParseException {
        LOGGER.debug("reading field {}. Count: {}", (Object)logicalName, (Object)count);
        if (count > Integer.MAX_VALUE) {
            throw new ParseException("Array count of " + count + " exceeds the maximum allowed count of " + Integer.MAX_VALUE);
        }
        readerArgs = (WithReaderArgs[])ArrayUtils.add((Object[])readerArgs, (Object)WithReaderWriterArgs.WithRenderAsList(true));
        dataReader.pullContext(logicalName, readerArgs);
        int itemCount = Math.max(0, (int)count);
        ArrayList<T> result = new ArrayList<T>(itemCount);
        int curItem = 0;
        while (curItem < itemCount) {
            ThreadLocalHelper.lastItemThreadLocal.set(curItem == itemCount - 1);
            result.add(dataReader.read("", readerArgs));
            ++curItem;
        }
        dataReader.closeContext(logicalName, readerArgs);
        LOGGER.debug("done reading field {}", (Object)logicalName);
        return result;
    }

    public List<T> readFieldLength(String logicalName, DataReader<T> dataReader, int length, WithReaderArgs ... readerArgs) throws ParseException {
        LOGGER.debug("reading field {}. Length: {}", (Object)logicalName, (Object)length);
        readerArgs = (WithReaderArgs[])ArrayUtils.add((Object[])readerArgs, (Object)WithReaderWriterArgs.WithRenderAsList(true));
        dataReader.pullContext(logicalName, readerArgs);
        int startPos = dataReader.getPos();
        ArrayList<T> result = new ArrayList<T>();
        int numberOfElements = 0;
        int stopPosition = startPos + length;
        LOGGER.debug("start reading at pos {} while < {}", (Object)startPos, (Object)stopPosition);
        while (dataReader.getPos() < stopPosition) {
            T element = dataReader.read("", readerArgs);
            LOGGER.debug("Read element[{}] {}", (Object)(++numberOfElements), element);
            result.add(element);
        }
        dataReader.closeContext(logicalName, readerArgs);
        LOGGER.debug("done reading field {}", (Object)logicalName);
        return result;
    }

    public List<T> readFieldTerminated(String logicalName, DataReader<T> dataReader, Supplier<Boolean> termination, WithReaderArgs ... readerArgs) throws ParseException {
        LOGGER.debug("reading field {}", (Object)logicalName);
        readerArgs = (WithReaderArgs[])ArrayUtils.add((Object[])readerArgs, (Object)WithReaderWriterArgs.WithRenderAsList(true));
        dataReader.pullContext(logicalName, readerArgs);
        ArrayList<T> result = new ArrayList<T>();
        while (!termination.get().booleanValue()) {
            result.add(dataReader.read("", readerArgs));
        }
        dataReader.closeContext(logicalName, readerArgs);
        LOGGER.debug("done reading field {}", (Object)logicalName);
        return result;
    }
}

