/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.jmx.kafkajmx;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.collector.collect.jmx.JmxValidator;
import org.apache.hertzbeat.collector.collect.jmx.MbeanProcessor;
import org.apache.hertzbeat.collector.collect.jmx.kafkajmx.kafkaprocessor.KafkaBytesInAndOutPerSecProcessor;
import org.apache.hertzbeat.collector.collect.jmx.kafkajmx.kafkaprocessor.KafkaCommonProcessor;
import org.apache.hertzbeat.collector.collect.jmx.kafkajmx.kafkaprocessor.KafkaReplicaManageProcessor;

public class KafkaJmxValidator
implements JmxValidator {
    private static final Map<String, Supplier<MbeanProcessor>> OBJECT_NAME_MAP;

    @Override
    public boolean isValid(String objectName) {
        if (StringUtils.isBlank((CharSequence)objectName)) {
            return false;
        }
        return OBJECT_NAME_MAP.keySet().stream().anyMatch(pattern -> objectName.matches((String)pattern));
    }

    @Override
    public MbeanProcessor getProcessor(String objectName) {
        if (StringUtils.isBlank((CharSequence)objectName)) {
            return null;
        }
        return OBJECT_NAME_MAP.entrySet().stream().filter(entry -> objectName.matches((String)entry.getKey())).map(entry -> (MbeanProcessor)((Supplier)entry.getValue()).get()).findFirst().orElse(null);
    }

    static {
        HashMap<String, Supplier<MbeanProcessor>> map = new HashMap<String, Supplier<MbeanProcessor>>();
        map.put("kafka\\.server:type=BrokerTopicMetrics,name=BytesInPerSec,topic=\\*", KafkaBytesInAndOutPerSecProcessor::new);
        map.put("kafka\\.server:type=BrokerTopicMetrics,name=BytesOutPerSec,topic=\\*", KafkaBytesInAndOutPerSecProcessor::new);
        map.put("kafka\\.server:type=ReplicaManager,name=\\*", KafkaReplicaManageProcessor::new);
        map.put("kafka\\.controller:type=KafkaController,name=\\*", KafkaCommonProcessor::new);
        map.put("kafka\\..*:type=GroupMetadataManager,name=\\*", KafkaCommonProcessor::new);
        OBJECT_NAME_MAP = Collections.unmodifiableMap(map);
    }
}

