/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.mode;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hbase.hbtop.Record;
import org.apache.hadoop.hbase.hbtop.RecordFilter;
import org.apache.hadoop.hbase.hbtop.field.Field;

public final class ModeStrategyUtils {
    private ModeStrategyUtils() {
    }

    public static List<Record> applyFilterAndGet(List<Record> records, List<RecordFilter> filters) {
        if (filters != null && !filters.isEmpty()) {
            return records.stream().filter(r -> filters.stream().allMatch(f -> f.execute((Record)r))).collect(Collectors.toList());
        }
        return records;
    }

    public static List<Record> aggregateRecords(List<Record> records, Field groupBy) {
        return records.stream().collect(Collectors.groupingBy(r -> r.get((Object)groupBy))).entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().reduce(Record::combine).map(Stream::of).orElse(Stream.empty())).collect(Collectors.toList());
    }
}

