/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sink.constraint;

import java.util.Arrays;
import java.util.BitSet;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.UpdatableRowData;
import org.apache.flink.table.runtime.operators.sink.constraint.Constraint;
import org.apache.flink.table.runtime.operators.sink.constraint.EnforcerException;
import org.apache.flink.table.runtime.operators.sink.constraint.TypeLengthEnforcementStrategy;

@Internal
final class BinaryLengthConstraint
implements Constraint {
    private final TypeLengthEnforcementStrategy typeLengthEnforcementStrategy;
    private final int[] fieldIndices;
    private final int[] fieldLengths;
    private final String[] fieldNames;
    private final BitSet fieldCouldPad;

    BinaryLengthConstraint(TypeLengthEnforcementStrategy typeLengthEnforcementStrategy, int[] fieldIndices, int[] fieldLengths, String[] fieldNames, BitSet fieldCouldPad) {
        this.typeLengthEnforcementStrategy = typeLengthEnforcementStrategy;
        this.fieldIndices = fieldIndices;
        this.fieldLengths = fieldLengths;
        this.fieldNames = fieldNames;
        this.fieldCouldPad = fieldCouldPad;
    }

    @Override
    @Nullable
    public RowData enforce(RowData rowData) {
        RowData updatedRowData = null;
        block4: for (int i = 0; i < this.fieldLengths.length; ++i) {
            int fieldIdx = this.fieldIndices[i];
            int expectedLength = this.fieldLengths[i];
            byte[] binaryData = rowData.getBinary(fieldIdx);
            int actualLength = binaryData.length;
            boolean shouldPad = this.fieldCouldPad.get(i);
            if (actualLength <= expectedLength && (!shouldPad || actualLength >= expectedLength)) continue;
            switch (this.typeLengthEnforcementStrategy) {
                case TRIM_PAD: {
                    updatedRowData = BinaryLengthConstraint.trimOrPad(rowData, (UpdatableRowData)updatedRowData, fieldIdx, binaryData, expectedLength);
                    continue block4;
                }
                case THROW: {
                    throw new EnforcerException("Column '%s'" + String.format(" is %s, however, a string of length %s is being written into it. You can set job configuration '%s' to control this behaviour.", (shouldPad ? "BINARY(" : "VARBINARY(") + expectedLength + ")", actualLength, ExecutionConfigOptions.TABLE_EXEC_SINK_TYPE_LENGTH_ENFORCER.key()), this.fieldNames[i]);
                }
            }
        }
        return updatedRowData != null ? updatedRowData : rowData;
    }

    private static UpdatableRowData trimOrPad(RowData rowData, UpdatableRowData updatedRowData, int fieldIdx, byte[] binaryData, int length) {
        if (updatedRowData == null) {
            updatedRowData = new UpdatableRowData(rowData, rowData.getArity());
        }
        updatedRowData.setField(fieldIdx, Arrays.copyOf(binaryData, length));
        return updatedRowData;
    }

    public String toString() {
        return String.format("LengthEnforcer(fields=[%s])", String.join((CharSequence)", ", this.fieldNames));
    }
}

