/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
public final class LeadLagInputTypeStrategy
implements InputTypeStrategy {
    private static final ArgumentTypeStrategy NUMERIC_ARGUMENT = InputTypeStrategies.logical(LogicalTypeFamily.NUMERIC);

    @Override
    public ArgumentCount getArgumentCount() {
        return ConstantArgumentCount.between(1, 3);
    }

    @Override
    public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        if (argumentDataTypes.size() == 1) {
            return Optional.of(argumentDataTypes);
        }
        Optional<DataType> offsetArg = NUMERIC_ARGUMENT.inferArgumentType(callContext, 1, throwOnFailure);
        if (!offsetArg.isPresent()) {
            return Optional.empty();
        }
        DataType arg0 = argumentDataTypes.get(0);
        if (argumentDataTypes.size() == 2) {
            return Optional.of(Arrays.asList(arg0, offsetArg.get()));
        }
        LogicalType defaultType = argumentDataTypes.get(2).getLogicalType();
        Optional<LogicalType> commonType = LogicalTypeMerging.findCommonType(Arrays.asList(arg0.getLogicalType(), defaultType));
        if (!commonType.isPresent()) {
            return callContext.fail(throwOnFailure, "The default value must have a common type with the given expression. ARG0: %s, default: %s", arg0, defaultType);
        }
        DataType commonDataType = commonType.map(TypeConversions::fromLogicalToDataType).get();
        return Optional.of(Arrays.asList(commonDataType, offsetArg.get(), commonDataType));
    }

    @Override
    public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
        return Arrays.asList(Signature.of(Signature.Argument.ofGroup("ANY")), Signature.of(Signature.Argument.ofGroup("ANY"), Signature.Argument.ofGroup("NUMERIC")), Signature.of(Signature.Argument.ofGroup("COMMON"), Signature.Argument.ofGroup("NUMERIC"), Signature.Argument.ofGroup("COMMON")));
    }
}

