/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Util;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ExprCodeGenerator;
import org.apache.flink.table.planner.codegen.FunctionCodeGenerator$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.hint.JoinStrategy;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.spec.JoinSpec;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalJoin;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalSnapshot;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalJoinBase;
import org.apache.flink.table.planner.plan.utils.FlinkRelMdUtil$;
import org.apache.flink.table.planner.plan.utils.IntervalJoinUtil$;
import org.apache.flink.table.planner.plan.utils.JoinTypeUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.plan.utils.TemporalJoinUtil$;
import org.apache.flink.table.planner.plan.utils.WindowJoinUtil$;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.stream.utils.JoinInputSideSpec;
import org.apache.flink.table.runtime.types.PlannerTypeUtils;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Tuple4;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class JoinUtil$ {
    public static JoinUtil$ MODULE$;

    static {
        new JoinUtil$();
    }

    public JoinSpec createJoinSpec(Join join) {
        ArrayList<Boolean> filterNulls = new ArrayList<Boolean>();
        JoinInfo joinInfo = this.createJoinInfo(join.getLeft(), join.getRight(), join.getCondition(), filterNulls);
        RexNode nonEquiCondition = RexUtil.composeConjunction(join.getCluster().getRexBuilder(), joinInfo.nonEquiConditions);
        return new JoinSpec(JoinTypeUtil.getFlinkJoinType(join.getJoinType()), joinInfo.leftKeys.toIntArray(), joinInfo.rightKeys.toIntArray(), (boolean[])((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(filterNulls).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean()), nonEquiCondition);
    }

    public void validateJoinSpec(JoinSpec joinSpec, RowType leftType, RowType rightType, boolean allowEmptyKey) {
        if (new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(joinSpec.getLeftKeys())).isEmpty() && !allowEmptyKey) {
            throw new TableException(new StringBuilder(163).append("Joins should have at least one equality condition.\n").append("\tLeft type: ").append(leftType).append("\n\tright type: ").append(rightType).append("\n").append("please re-check the join statement and make sure there's ").append("equality condition for join.").toString());
        }
        int[] leftKeys = joinSpec.getLeftKeys();
        int[] rightKeys = joinSpec.getRightKeys();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), joinSpec.getJoinKeySize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
            LogicalType rightKeyType;
            LogicalType leftKeyType = leftType.getTypeAt(leftKeys[idx]);
            if (!PlannerTypeUtils.isInteroperable((LogicalType)leftKeyType, (LogicalType)(rightKeyType = rightType.getTypeAt(rightKeys[idx])))) {
                throw new TableException(new StringBuilder(115).append("Join: Equality join predicate on incompatible types. ").append("\tLeft type: ").append(leftType).append("\n\tright type: ").append(rightType).append("\n").append("please re-check the join statement.").toString());
            }
        });
    }

    public boolean validateJoinSpec$default$4() {
        return false;
    }

    public JoinInfo createJoinInfo(RelNode left, RelNode right, RexNode condition, List<Boolean> filterNulls) {
        ArrayList<Integer> leftKeys = new ArrayList<Integer>();
        ArrayList<Integer> rightKeys = new ArrayList<Integer>();
        RexNode remaining = RelOptUtil.splitJoinCondition(left, right, condition, leftKeys, rightKeys, filterNulls);
        if (remaining.isAlwaysTrue()) {
            return JoinInfo.of(ImmutableIntList.copyOf(leftKeys), ImmutableIntList.copyOf(rightKeys));
        }
        return JoinInfo.of(left, right, condition);
    }

    public GeneratedJoinCondition generateConditionFunction(ReadableConfig tableConfig, ClassLoader classLoader, JoinSpec joinSpec, LogicalType leftType, LogicalType rightType) {
        return this.generateConditionFunction(tableConfig, classLoader, (RexNode)joinSpec.getNonEquiCondition().orElse(null), leftType, rightType);
    }

    public GeneratedJoinCondition generateConditionFunction(ReadableConfig tableConfig, ClassLoader classLoader, RexNode nonEquiCondition, LogicalType leftType, LogicalType rightType) {
        String string;
        CodeGeneratorContext ctx = new CodeGeneratorContext(tableConfig, classLoader);
        ExprCodeGenerator qual$1 = new ExprCodeGenerator(ctx, false);
        LogicalType x$1 = leftType;
        String x$2 = qual$1.bindInput$default$2();
        Option<int[]> x$3 = qual$1.bindInput$default$3();
        ExprCodeGenerator qual$2 = qual$1.bindInput(x$1, x$2, x$3);
        LogicalType x$4 = rightType;
        String x$5 = qual$2.bindSecondInput$default$2();
        Option<int[]> x$6 = qual$2.bindSecondInput$default$3();
        ExprCodeGenerator exprGenerator = qual$2.bindSecondInput(x$4, x$5, x$6);
        if (nonEquiCondition == null) {
            string = "return true;";
        } else {
            GeneratedExpression condition = exprGenerator.generateExpression(nonEquiCondition);
            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(41).append("\n         |").append(condition.code()).append("\n         |return ").append(condition.resultTerm()).append(";\n         |").toString())).stripMargin();
        }
        String body = string;
        return FunctionCodeGenerator$.MODULE$.generateJoinCondition(ctx, "ConditionFunction", body, FunctionCodeGenerator$.MODULE$.generateJoinCondition$default$4(), FunctionCodeGenerator$.MODULE$.generateJoinCondition$default$5());
    }

    public JoinInputSideSpec analyzeJoinInput(ClassLoader classLoader, InternalTypeInfo<RowData> inputTypeInfo, int[] joinKeys, List<int[]> uniqueKeys) {
        if (uniqueKeys == null || uniqueKeys.isEmpty()) {
            return JoinInputSideSpec.withoutUniqueKey();
        }
        HashSet joinKeySet = new HashSet();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(joinKeys)).map((Function1 & Serializable & scala.Serializable)x -> JoinUtil$.$anonfun$analyzeJoinInput$1(BoxesRunTime.unboxToInt((Object)x)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Integer.class))))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)joinKeySet.add(x$1)));
        Buffer uniqueKeysContainedByJoinKey = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(uniqueKeys).filter((Function1 & Serializable & scala.Serializable)uk -> BoxesRunTime.boxToBoolean((boolean)joinKeySet.containsAll(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(uk)).toList()))));
        if (uniqueKeysContainedByJoinKey.isEmpty()) {
            int[] smallestUniqueKey = this.getSmallestKey(uniqueKeys);
            RowDataKeySelector uniqueKeySelector = KeySelectorUtil.getRowDataSelector(classLoader, smallestUniqueKey, inputTypeInfo);
            InternalTypeInfo uniqueKeyTypeInfo = uniqueKeySelector.getProducedType();
            return JoinInputSideSpec.withUniqueKey((InternalTypeInfo)uniqueKeyTypeInfo, (KeySelector)uniqueKeySelector);
        }
        int[] smallestUniqueKey = this.getSmallestKey(JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(uniqueKeysContainedByJoinKey));
        RowDataKeySelector uniqueKeySelector = KeySelectorUtil.getRowDataSelector(classLoader, smallestUniqueKey, inputTypeInfo);
        InternalTypeInfo uniqueKeyTypeInfo = uniqueKeySelector.getProducedType();
        return JoinInputSideSpec.withUniqueKeyContainedByJoinKey((InternalTypeInfo)uniqueKeyTypeInfo, (KeySelector)uniqueKeySelector);
    }

    private int[] getSmallestKey(List<int[]> keys) {
        return (int[])JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(keys).reduce((Function2 & Serializable & scala.Serializable)(k1, k2) -> {
            if (((int[])k1).length <= ((int[])k2).length) {
                return k1;
            }
            return k2;
        });
    }

    public boolean accessesTimeAttribute(RexNode expr, RelDataType inputType) {
        RexNode rexNode = expr;
        if (rexNode instanceof RexInputRef) {
            RexInputRef rexInputRef = (RexInputRef)rexNode;
            RelDataType accessedType = inputType.getFieldList().get(rexInputRef.getIndex()).getType();
            return FlinkTypeFactory$.MODULE$.isTimeIndicatorType(accessedType);
        }
        if (rexNode instanceof RexCall) {
            RexCall rexCall = (RexCall)rexNode;
            return JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rexCall.operands).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JoinUtil$.MODULE$.accessesTimeAttribute(x$2, inputType)));
        }
        return false;
    }

    public RelDataType combineJoinInputsRowType(Join join) {
        JoinRelType joinRelType = join.getJoinType();
        if (((Object)((Object)JoinRelType.SEMI)).equals((Object)joinRelType) ? true : ((Object)((Object)JoinRelType.ANTI)).equals((Object)joinRelType)) {
            return SqlValidatorUtil.createJoinType(join.getCluster().getTypeFactory(), join.getLeft().getRowType(), join.getRight().getRowType(), null, Collections.emptyList());
        }
        return join.getRowType();
    }

    public boolean satisfyRegularJoin(FlinkLogicalJoin join, RelNode newLeft, RelNode newRight) {
        if (newRight instanceof FlinkLogicalSnapshot) {
            return false;
        }
        if (TemporalJoinUtil$.MODULE$.satisfyTemporalJoin(join, newLeft, newRight)) {
            return false;
        }
        if (IntervalJoinUtil$.MODULE$.satisfyIntervalJoin(join, newLeft, newRight)) {
            return false;
        }
        return !WindowJoinUtil$.MODULE$.satisfyWindowJoin(join, newLeft, newRight);
    }

    public Double binaryRowRelNodeSize(RelNode relNode) {
        RelMetadataQuery mq = relNode.getCluster().getMetadataQuery();
        Double rowCount = mq.getRowCount(relNode);
        if (rowCount == null) {
            return null;
        }
        return Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(rowCount) * Predef$.MODULE$.Double2double(FlinkRelMdUtil$.MODULE$.binaryRowAverageSize(relNode)));
    }

    public long getManagedMemory(FlinkJoinType joinType, ExecNodeConfig config) {
        long hashJoinManagedMemory = ((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_HASH_JOIN_MEMORY)).getBytes();
        long externalBufferMemory = ((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_EXTERNAL_BUFFER_MEMORY)).getBytes();
        long sortMemory = ((MemorySize)config.get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_SORT_MEMORY)).getBytes();
        int externalBufferNum = 1;
        if (joinType == FlinkJoinType.FULL) {
            externalBufferNum = 2;
        }
        long sortMergeJoinManagedMemory = externalBufferMemory * (long)externalBufferNum + sortMemory * 2L;
        return Math.max(hashJoinManagedMemory, sortMergeJoinManagedMemory);
    }

    public Tuple4<Object, Object, Object, Object> getEstimatedRowStats(BatchPhysicalJoinBase joinBase) {
        RelMetadataQuery mq = joinBase.getCluster().getMetadataQuery();
        int leftRowSize = (int)Util.first(mq.getAverageRowSize(joinBase.getLeft()), 24.0);
        long leftRowCount = (long)Util.first(mq.getRowCount(joinBase.getLeft()), 200000.0);
        int rightRowSize = (int)Util.first(mq.getAverageRowSize(joinBase.getRight()), 24.0);
        long rightRowCount = (long)Util.first(mq.getRowCount(joinBase.getRight()), 200000.0);
        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)leftRowSize), (Object)BoxesRunTime.boxToLong((long)leftRowCount), (Object)BoxesRunTime.boxToInteger((int)rightRowSize), (Object)BoxesRunTime.boxToLong((long)rightRowCount));
    }

    public boolean containsJoinStrategyHint(ImmutableList<RelHint> relHints) {
        return JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(relHints).exists((Function1 & Serializable & scala.Serializable)relHint -> BoxesRunTime.boxToBoolean((boolean)JoinUtil$.$anonfun$containsJoinStrategyHint$1(relHint)));
    }

    public static final /* synthetic */ Integer $anonfun$analyzeJoinInput$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ boolean $anonfun$containsJoinStrategyHint$1(RelHint relHint) {
        return JoinStrategy.isJoinStrategy(relHint.hintName);
    }

    private JoinUtil$() {
        MODULE$ = this;
    }
}

