/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.ddl.SqlCreateModel;
import org.apache.flink.sql.parser.error.SqlValidateException;

public class SqlCreateModelAs
extends SqlCreateModel {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE MODEL AS", SqlKind.OTHER_DDL);
    private final SqlNode asQuery;

    public SqlCreateModelAs(SqlParserPos pos, SqlIdentifier modelName, SqlCharStringLiteral comment, SqlNodeList inputColumnList, SqlNodeList outputColumnList, SqlNodeList propertyList, SqlNode asQuery, boolean isTemporary, boolean ifNotExists) {
        super(pos, modelName, comment, inputColumnList, outputColumnList, propertyList, isTemporary, ifNotExists);
        this.asQuery = Objects.requireNonNull(asQuery, "As clause is required for CREATE MODEL AS SELECT DDL");
    }

    @Override
    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.builder().addAll(super.getOperandList()).add(this.asQuery).build();
    }

    @Override
    public void validate() throws SqlValidateException {
        if (!this.getInputColumnList().isEmpty()) {
            throw new SqlValidateException(this.getParserPosition(), "CREATE MODEL AS SELECT syntax does not support to specify explicit input columns.");
        }
        if (!this.getOutputColumnList().isEmpty()) {
            throw new SqlValidateException(this.getParserPosition(), "CREATE MODEL AS SELECT syntax does not support to specify explicit output columns.");
        }
        super.validate();
    }

    public SqlNode getAsQuery() {
        return this.asQuery;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.newlineAndIndent();
        writer.keyword("AS");
        writer.newlineAndIndent();
        this.asQuery.unparse(writer, leftPrec, rightPrec);
    }
}

