/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.services.s3.transfer.Upload;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;

public class ProgressableProgressListener
implements ProgressListener {
    private static final Logger LOG = S3AFileSystem.LOG;
    private final S3AFileSystem fs;
    private final String key;
    private final Progressable progress;
    private long lastBytesTransferred;
    private final Upload upload;

    public ProgressableProgressListener(S3AFileSystem fs, String key, Upload upload, Progressable progress) {
        this.fs = fs;
        this.key = key;
        this.upload = upload;
        this.progress = progress;
        this.lastBytesTransferred = 0L;
    }

    @Override
    public void progressChanged(ProgressEvent progressEvent) {
        ProgressEventType pet;
        if (this.progress != null) {
            this.progress.progress();
        }
        if ((pet = progressEvent.getEventType()) == ProgressEventType.TRANSFER_PART_STARTED_EVENT || pet == ProgressEventType.TRANSFER_COMPLETED_EVENT) {
            this.fs.incrementWriteOperations();
        }
        long transferred = this.upload.getProgress().getBytesTransferred();
        long delta = transferred - this.lastBytesTransferred;
        this.fs.incrementPutProgressStatistics(this.key, delta);
        this.lastBytesTransferred = transferred;
    }

    public long uploadCompleted() {
        long delta = this.upload.getProgress().getBytesTransferred() - this.lastBytesTransferred;
        if (delta > 0L) {
            LOG.debug("S3A write delta changed after finished: {} bytes", (Object)delta);
            this.fs.incrementPutProgressStatistics(this.key, delta);
        }
        return delta;
    }
}

