/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.meeting.domain;

import org.apache.fineract.portfolio.meeting.domain.Meeting;
import org.apache.fineract.portfolio.meeting.domain.MeetingRepository;
import org.apache.fineract.portfolio.meeting.exception.MeetingNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MeetingRepositoryWrapper {
    private final MeetingRepository repository;

    @Autowired
    public MeetingRepositoryWrapper(MeetingRepository repository) {
        this.repository = repository;
    }

    public Meeting findOneWithNotFoundDetection(Long meetingId) {
        return (Meeting)this.repository.findById((Object)meetingId).orElseThrow(() -> new MeetingNotFoundException(meetingId));
    }

    public void save(Meeting meeting) {
        this.repository.save((Object)meeting);
    }

    public void delete(Meeting meeting) {
        this.repository.delete((Object)meeting);
    }

    public void saveAndFlush(Meeting meeting) {
        this.repository.saveAndFlush((Object)meeting);
    }
}

