/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.event.external.producer.jms;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.core.diagnostics.performance.MeasuringUtil;
import org.apache.fineract.infrastructure.core.messaging.jms.MessageFactory;
import org.apache.fineract.infrastructure.core.service.HashingService;
import org.apache.fineract.infrastructure.event.external.exception.AcknowledgementTimeoutException;
import org.apache.fineract.infrastructure.event.external.producer.ExternalEventProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"fineract.events.external.producer.jms.enabled"}, havingValue="true")
public class JMSMultiExternalEventProducer
implements ExternalEventProducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JMSMultiExternalEventProducer.class);
    @Qualifier(value="externalEventDestination")
    private final Destination destination;
    @Qualifier(value="externalEventConnectionFactory")
    private final ConnectionFactory connectionFactory;
    private final MessageFactory messageFactory;
    @Qualifier(value="externalEventJmsProducerExecutor")
    private final AsyncTaskExecutor taskExecutor;
    private final HashingService hashingService;
    private final FineractProperties fineractProperties;

    private int getProducerCount() {
        return this.fineractProperties.getEvents().getExternal().getProducer().getJms().getProducerCount();
    }

    public void sendEvents(Map<Long, List<byte[]>> partitions) throws AcknowledgementTimeoutException {
        Map indexedPartitions = this.mapPartitionsToProducers(partitions);
        MeasuringUtil.measure(() -> {
            List producersWithSessions = this.obtainProducers();
            List producers = producersWithSessions.stream().map(Pair::getRight).collect(Collectors.toList());
            List sessions = producersWithSessions.stream().map(Pair::getLeft).collect(Collectors.toList());
            List tasks = this.sendPartitions(indexedPartitions, producers);
            this.waitForSendingCompletion(tasks);
            this.closeSessions(sessions);
        }, timeTaken -> {
            if (log.isDebugEnabled()) {
                int eventCount = partitions.values().stream().map(Collection::size).reduce(0, Integer::sum);
                int msgPerSec = (int)((double)eventCount / (double)timeTaken.toMillis() * 1000.0);
                log.debug("Sent messages with {} msg/s", (Object)msgPerSec);
            }
        });
    }

    private void closeSessions(List<Session> sessions) {
        for (Session session : sessions) {
            try {
                session.close();
            }
            catch (JMSException e) {
                log.error("Exception while trying to close sessions", (Throwable)e);
            }
        }
    }

    private List<Pair<Session, MessageProducer>> obtainProducers() {
        ArrayList<Pair<Session, MessageProducer>> result = new ArrayList<Pair<Session, MessageProducer>>();
        int producerCount = this.getProducerCount();
        try {
            Connection connection = this.connectionFactory.createConnection();
            for (int i = 0; i < producerCount; ++i) {
                Session session = connection.createSession(false, 1);
                MessageProducer producer = session.createProducer(this.destination);
                result.add((Pair<Session, MessageProducer>)new ImmutablePair((Object)session, (Object)producer));
            }
        }
        catch (JMSException e) {
            throw new RuntimeException("Error while obtaining message producers", e);
        }
        return result;
    }

    private List<Future<?>> sendPartitions(Map<Integer, List<byte[]>> indexedPartitions, List<MessageProducer> producers) {
        ArrayList tasks = new ArrayList();
        for (Map.Entry<Integer, List<byte[]>> entry : indexedPartitions.entrySet()) {
            Integer producerIndex = entry.getKey();
            MessageProducer producer = producers.get(producerIndex);
            List<byte[]> messages = entry.getValue();
            Future future = this.createSendingTask(producer, messages);
            tasks.add(future);
        }
        return tasks;
    }

    private Future<?> createSendingTask(MessageProducer messageProducer, List<byte[]> messages) {
        return this.taskExecutor.submit(() -> {
            for (byte[] message : messages) {
                try {
                    messageProducer.send(this.destination, (Message)this.messageFactory.createByteMessage(message));
                }
                catch (JMSException e) {
                    throw new RuntimeException("Error while sending the message", e);
                }
            }
        });
    }

    private Map<Integer, List<byte[]>> mapPartitionsToProducers(Map<Long, List<byte[]>> partitions) {
        HashMap<Integer, List<byte[]>> indexedPartitions = new HashMap<Integer, List<byte[]>>();
        for (Map.Entry<Long, List<byte[]>> partition : partitions.entrySet()) {
            Long key = partition.getKey();
            List<byte[]> messages = partition.getValue();
            int producerIndex = this.hashingService.consistentHash(key.longValue(), this.getProducerCount());
            indexedPartitions.putIfAbsent(producerIndex, new ArrayList());
            ((List)indexedPartitions.get(producerIndex)).addAll(messages);
        }
        return indexedPartitions;
    }

    private void waitForSendingCompletion(List<Future<?>> tasks) {
        try {
            for (Future<?> task : tasks) {
                task.get();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public JMSMultiExternalEventProducer(@Qualifier(value="externalEventDestination") Destination destination, @Qualifier(value="externalEventConnectionFactory") ConnectionFactory connectionFactory, MessageFactory messageFactory, @Qualifier(value="externalEventJmsProducerExecutor") AsyncTaskExecutor taskExecutor, HashingService hashingService, FineractProperties fineractProperties) {
        this.destination = destination;
        this.connectionFactory = connectionFactory;
        this.messageFactory = messageFactory;
        this.taskExecutor = taskExecutor;
        this.hashingService = hashingService;
        this.fineractProperties = fineractProperties;
    }
}

