/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.Version;
import jakarta.xml.bind.annotation.XmlTransient;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import lombok.Generated;
import org.apache.fineract.cob.domain.LockOwner;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;

@Entity
@Table(name="m_loan_account_locks")
public class LoanAccountLock
implements Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
ChangeTracker,
PersistenceWeavedChangeTracking {
    @Id
    @Column(name="loan_id", nullable=false)
    private Long loanId;
    @Version
    @Column(name="version")
    private Long version;
    @Enumerated(value=EnumType.STRING)
    @Column(name="lock_owner", nullable=false)
    private LockOwner lockOwner;
    @Column(name="lock_placed_on", nullable=false)
    private OffsetDateTime lockPlacedOn;
    @Column(name="error")
    private String error;
    @Column(name="stacktrace")
    private String stacktrace;
    @Column(name="lock_placed_on_cob_business_date")
    private LocalDate lockPlacedOnCobBusinessDate;
    static final long serialVersionUID = -874910999661169209L;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    protected transient PropertyChangeListener _persistence_listener;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;

    public LoanAccountLock(Long loanId, LockOwner lockOwner, LocalDate lockPlacedOnCobBusinessDate) {
        this.loanId = loanId;
        this.lockOwner = lockOwner;
        this.lockPlacedOn = DateUtils.getAuditOffsetDateTime();
        this.lockPlacedOnCobBusinessDate = lockPlacedOnCobBusinessDate;
    }

    public void setError(String errorMessage, String stacktrace) {
        this._persistence_set_error(errorMessage);
        this._persistence_set_stacktrace(stacktrace);
    }

    public void setNewLockOwner(LockOwner newLockOwner) {
        this._persistence_set_lockOwner(newLockOwner);
        this._persistence_set_lockPlacedOn(DateUtils.getAuditOffsetDateTime());
    }

    @Generated
    public LoanAccountLock() {
    }

    @Generated
    public Long getLoanId() {
        return this._persistence_get_loanId();
    }

    @Generated
    public Long getVersion() {
        return this._persistence_get_version();
    }

    @Generated
    public LockOwner getLockOwner() {
        return this._persistence_get_lockOwner();
    }

    @Generated
    public OffsetDateTime getLockPlacedOn() {
        return this._persistence_get_lockPlacedOn();
    }

    @Generated
    public String getError() {
        return this._persistence_get_error();
    }

    @Generated
    public String getStacktrace() {
        return this._persistence_get_stacktrace();
    }

    @Generated
    public LocalDate getLockPlacedOnCobBusinessDate() {
        return this._persistence_get_lockPlacedOnCobBusinessDate();
    }

    public Object _persistence_post_clone() {
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new LoanAccountLock(persistenceObject);
    }

    public LoanAccountLock(PersistenceObject persistenceObject) {
    }

    public Object _persistence_get(String string) {
        if (string == "lockPlacedOn") {
            return this.lockPlacedOn;
        }
        if (string == "stacktrace") {
            return this.stacktrace;
        }
        if (string == "lockOwner") {
            return this.lockOwner;
        }
        if (string == "error") {
            return this.error;
        }
        if (string == "version") {
            return this.version;
        }
        if (string == "lockPlacedOnCobBusinessDate") {
            return this.lockPlacedOnCobBusinessDate;
        }
        if (string == "loanId") {
            return this.loanId;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "lockPlacedOn") {
            this.lockPlacedOn = (OffsetDateTime)object;
            return;
        }
        if (string == "stacktrace") {
            this.stacktrace = (String)object;
            return;
        }
        if (string == "lockOwner") {
            this.lockOwner = (LockOwner)object;
            return;
        }
        if (string == "error") {
            this.error = (String)object;
            return;
        }
        if (string == "version") {
            this.version = (Long)object;
            return;
        }
        if (string == "lockPlacedOnCobBusinessDate") {
            this.lockPlacedOnCobBusinessDate = (LocalDate)object;
            return;
        }
        if (string == "loanId") {
            this.loanId = (Long)object;
            return;
        }
    }

    public OffsetDateTime _persistence_get_lockPlacedOn() {
        this._persistence_checkFetched("lockPlacedOn");
        return this.lockPlacedOn;
    }

    public void _persistence_set_lockPlacedOn(OffsetDateTime offsetDateTime) {
        this._persistence_checkFetchedForSet("lockPlacedOn");
        this._persistence_propertyChange("lockPlacedOn", (Object)this.lockPlacedOn, (Object)offsetDateTime);
        this.lockPlacedOn = offsetDateTime;
    }

    public String _persistence_get_stacktrace() {
        this._persistence_checkFetched("stacktrace");
        return this.stacktrace;
    }

    public void _persistence_set_stacktrace(String string) {
        this._persistence_checkFetchedForSet("stacktrace");
        this._persistence_propertyChange("stacktrace", (Object)this.stacktrace, (Object)string);
        this.stacktrace = string;
    }

    public LockOwner _persistence_get_lockOwner() {
        this._persistence_checkFetched("lockOwner");
        return this.lockOwner;
    }

    public void _persistence_set_lockOwner(LockOwner lockOwner) {
        this._persistence_checkFetchedForSet("lockOwner");
        this._persistence_propertyChange("lockOwner", (Object)this.lockOwner, (Object)lockOwner);
        this.lockOwner = lockOwner;
    }

    public String _persistence_get_error() {
        this._persistence_checkFetched("error");
        return this.error;
    }

    public void _persistence_set_error(String string) {
        this._persistence_checkFetchedForSet("error");
        this._persistence_propertyChange("error", (Object)this.error, (Object)string);
        this.error = string;
    }

    public Long _persistence_get_version() {
        this._persistence_checkFetched("version");
        return this.version;
    }

    public void _persistence_set_version(Long l) {
        this._persistence_checkFetchedForSet("version");
        this._persistence_propertyChange("version", (Object)this.version, (Object)l);
        this.version = l;
    }

    public LocalDate _persistence_get_lockPlacedOnCobBusinessDate() {
        this._persistence_checkFetched("lockPlacedOnCobBusinessDate");
        return this.lockPlacedOnCobBusinessDate;
    }

    public void _persistence_set_lockPlacedOnCobBusinessDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("lockPlacedOnCobBusinessDate");
        this._persistence_propertyChange("lockPlacedOnCobBusinessDate", (Object)this.lockPlacedOnCobBusinessDate, (Object)localDate);
        this.lockPlacedOnCobBusinessDate = localDate;
    }

    public Long _persistence_get_loanId() {
        this._persistence_checkFetched("loanId");
        return this.loanId;
    }

    public void _persistence_set_loanId(Long l) {
        this._persistence_checkFetchedForSet("loanId");
        this._persistence_propertyChange("loanId", (Object)this.loanId, (Object)l);
        this.loanId = l;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this._persistence_listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._persistence_listener = propertyChangeListener;
    }

    public void _persistence_propertyChange(String string, Object object, Object object2) {
        if (this._persistence_listener != null && object != object2) {
            this._persistence_listener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)((FetchGroupTracker)this), (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)((FetchGroupTracker)this), (String)string);
        }
    }
}

