/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed;

import io.github.bucket4j.AbstractBucket;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketListener;
import io.github.bucket4j.ConsumptionProbe;
import io.github.bucket4j.EstimationProbe;
import io.github.bucket4j.Experimental;
import io.github.bucket4j.LimitChecker;
import io.github.bucket4j.Nothing;
import io.github.bucket4j.SchedulingBucket;
import io.github.bucket4j.TokensInheritanceStrategy;
import io.github.bucket4j.VerboseResult;
import io.github.bucket4j.distributed.AsyncBucketProxy;
import io.github.bucket4j.distributed.AsyncOptimizationController;
import io.github.bucket4j.distributed.AsyncVerboseBucket;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

@Experimental
public class AsyncBucketProxyAdapter
implements AsyncBucketProxy,
AsyncOptimizationController {
    private final Bucket target;
    private final AsyncVerboseBucket verboseView = new AsyncVerboseBucket(){

        @Override
        public CompletableFuture<VerboseResult<Boolean>> tryConsume(long numTokens) {
            return AbstractBucket.completedFuture(() -> AsyncBucketProxyAdapter.this.target.asVerbose().tryConsume(numTokens));
        }

        @Override
        public CompletableFuture<VerboseResult<Long>> consumeIgnoringRateLimits(long tokens) {
            return AbstractBucket.completedFuture(() -> AsyncBucketProxyAdapter.this.target.asVerbose().consumeIgnoringRateLimits(tokens));
        }

        @Override
        public CompletableFuture<VerboseResult<ConsumptionProbe>> tryConsumeAndReturnRemaining(long numTokens) {
            return AbstractBucket.completedFuture(() -> AsyncBucketProxyAdapter.this.target.asVerbose().tryConsumeAndReturnRemaining(numTokens));
        }

        @Override
        public CompletableFuture<VerboseResult<EstimationProbe>> estimateAbilityToConsume(long numTokens) {
            return AbstractBucket.completedFuture(() -> AsyncBucketProxyAdapter.this.target.asVerbose().estimateAbilityToConsume(numTokens));
        }

        @Override
        public CompletableFuture<VerboseResult<Long>> tryConsumeAsMuchAsPossible() {
            return AbstractBucket.completedFuture(() -> AsyncBucketProxyAdapter.this.target.asVerbose().tryConsumeAsMuchAsPossible());
        }

        @Override
        public CompletableFuture<VerboseResult<Long>> tryConsumeAsMuchAsPossible(long limit) {
            return AbstractBucket.completedFuture(() -> AsyncBucketProxyAdapter.this.target.asVerbose().tryConsumeAsMuchAsPossible(limit));
        }

        @Override
        public CompletableFuture<VerboseResult<Nothing>> addTokens(long tokensToAdd) {
            return AbstractBucket.completedFuture(() -> AsyncBucketProxyAdapter.this.target.asVerbose().addTokens(tokensToAdd));
        }

        @Override
        public CompletableFuture<VerboseResult<Nothing>> forceAddTokens(long tokensToAdd) {
            return AbstractBucket.completedFuture(() -> AsyncBucketProxyAdapter.this.target.asVerbose().forceAddTokens(tokensToAdd));
        }

        @Override
        public CompletableFuture<VerboseResult<Nothing>> reset() {
            return AbstractBucket.completedFuture(() -> AsyncBucketProxyAdapter.this.target.asVerbose().reset());
        }

        @Override
        public CompletableFuture<VerboseResult<Nothing>> replaceConfiguration(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
            LimitChecker.checkConfiguration(newConfiguration);
            LimitChecker.checkMigrationMode(tokensInheritanceStrategy);
            return AbstractBucket.completedFuture(() -> AsyncBucketProxyAdapter.this.target.asVerbose().replaceConfiguration(newConfiguration, tokensInheritanceStrategy));
        }

        @Override
        public CompletableFuture<VerboseResult<Long>> getAvailableTokens() {
            return AbstractBucket.completedFuture(() -> AsyncBucketProxyAdapter.this.target.asVerbose().getAvailableTokens());
        }
    };

    public static AsyncBucketProxy fromSync(Bucket bucket) {
        return new AsyncBucketProxyAdapter(bucket);
    }

    public AsyncBucketProxyAdapter(Bucket target) {
        this.target = Objects.requireNonNull(target);
    }

    @Override
    public SchedulingBucket asScheduler() {
        return this.target.asScheduler();
    }

    @Override
    public AsyncVerboseBucket asVerbose() {
        return this.verboseView;
    }

    @Override
    public CompletableFuture<Boolean> tryConsume(long numTokens) {
        return AbstractBucket.completedFuture(() -> this.target.tryConsume(numTokens));
    }

    @Override
    public CompletableFuture<Long> consumeIgnoringRateLimits(long tokens) {
        return AbstractBucket.completedFuture(() -> this.target.consumeIgnoringRateLimits(tokens));
    }

    @Override
    public CompletableFuture<ConsumptionProbe> tryConsumeAndReturnRemaining(long numTokens) {
        return AbstractBucket.completedFuture(() -> this.target.tryConsumeAndReturnRemaining(numTokens));
    }

    @Override
    public CompletableFuture<EstimationProbe> estimateAbilityToConsume(long numTokens) {
        return AbstractBucket.completedFuture(() -> this.target.estimateAbilityToConsume(numTokens));
    }

    @Override
    public CompletableFuture<Long> tryConsumeAsMuchAsPossible() {
        return AbstractBucket.completedFuture(() -> this.target.tryConsumeAsMuchAsPossible());
    }

    @Override
    public CompletableFuture<Long> tryConsumeAsMuchAsPossible(long limit) {
        return AbstractBucket.completedFuture(() -> this.target.tryConsumeAsMuchAsPossible(limit));
    }

    @Override
    public CompletableFuture<Void> addTokens(long tokensToAdd) {
        return AbstractBucket.completedFuture(() -> {
            this.target.addTokens(tokensToAdd);
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> forceAddTokens(long tokensToAdd) {
        return AbstractBucket.completedFuture(() -> {
            this.target.forceAddTokens(tokensToAdd);
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> reset() {
        return AbstractBucket.completedFuture(() -> {
            this.target.reset();
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> replaceConfiguration(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
        LimitChecker.checkConfiguration(newConfiguration);
        LimitChecker.checkMigrationMode(tokensInheritanceStrategy);
        return AbstractBucket.completedFuture(() -> {
            this.target.replaceConfiguration(newConfiguration, tokensInheritanceStrategy);
            return null;
        });
    }

    @Override
    public CompletableFuture<Long> getAvailableTokens() {
        return AbstractBucket.completedFuture(() -> this.target.getAvailableTokens());
    }

    @Override
    public AsyncOptimizationController getOptimizationController() {
        return this;
    }

    @Override
    public CompletableFuture<Void> syncImmediately() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> syncByCondition(long unsynchronizedTokens, Duration timeSinceLastSync) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public AsyncBucketProxy toListenable(BucketListener listener) {
        return new AsyncBucketProxyAdapter(this.target.toListenable(listener));
    }
}

