/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.ListOffsetsOptions;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.internals.AdminApiFuture;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.kafka.clients.admin.internals.PartitionLeaderStrategy;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.utils.CollectionUtils;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public final class ListOffsetsHandler
extends AdminApiHandler.Batched<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> {
    private final Map<TopicPartition, Long> offsetTimestampsByPartition;
    private final ListOffsetsOptions options;
    private final Logger log;
    private final AdminApiLookupStrategy<TopicPartition> lookupStrategy;

    public ListOffsetsHandler(Map<TopicPartition, Long> offsetTimestampsByPartition, ListOffsetsOptions options, LogContext logContext) {
        this.offsetTimestampsByPartition = offsetTimestampsByPartition;
        this.options = options;
        this.log = logContext.logger(ListOffsetsHandler.class);
        this.lookupStrategy = new PartitionLeaderStrategy(logContext, false);
    }

    @Override
    public String apiName() {
        return "listOffsets";
    }

    @Override
    public AdminApiLookupStrategy<TopicPartition> lookupStrategy() {
        return this.lookupStrategy;
    }

    ListOffsetsRequest.Builder buildBatchedRequest(int brokerId, Set<TopicPartition> keys) {
        Map<String, ListOffsetsRequestData.ListOffsetsTopic> topicsByName = CollectionUtils.groupPartitionsByTopic(keys, topicName -> new ListOffsetsRequestData.ListOffsetsTopic().setName((String)topicName), (listOffsetsTopic, partitionId) -> {
            TopicPartition topicPartition = new TopicPartition(listOffsetsTopic.name(), (int)partitionId);
            long offsetTimestamp = this.offsetTimestampsByPartition.get(topicPartition);
            listOffsetsTopic.partitions().add(new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex((int)partitionId).setTimestamp(offsetTimestamp));
        });
        boolean supportsMaxTimestamp = keys.stream().anyMatch(key -> this.offsetTimestampsByPartition.get(key) == -3L);
        boolean requireEarliestLocalTimestamp = keys.stream().anyMatch(key -> this.offsetTimestampsByPartition.get(key) == -4L);
        boolean requireTieredStorageTimestamp = keys.stream().anyMatch(key -> this.offsetTimestampsByPartition.get(key) == -5L);
        return ListOffsetsRequest.Builder.forConsumer(true, this.options.isolationLevel(), supportsMaxTimestamp, requireEarliestLocalTimestamp, requireTieredStorageTimestamp).setTargetTimes(new ArrayList<ListOffsetsRequestData.ListOffsetsTopic>(topicsByName.values()));
    }

    @Override
    public AdminApiHandler.ApiResult<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> handleResponse(Node broker, Set<TopicPartition> keys, AbstractResponse abstractResponse) {
        ListOffsetsResponse response = (ListOffsetsResponse)abstractResponse;
        HashMap<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> completed = new HashMap<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo>();
        HashMap<TopicPartition, Throwable> failed = new HashMap<TopicPartition, Throwable>();
        ArrayList<TopicPartition> unmapped = new ArrayList<TopicPartition>();
        HashSet<TopicPartition> retriable = new HashSet<TopicPartition>();
        for (ListOffsetsResponseData.ListOffsetsTopicResponse topic : response.topics()) {
            for (ListOffsetsResponseData.ListOffsetsPartitionResponse partition : topic.partitions()) {
                TopicPartition topicPartition = new TopicPartition(topic.name(), partition.partitionIndex());
                Errors error = Errors.forCode(partition.errorCode());
                if (!this.offsetTimestampsByPartition.containsKey(topicPartition)) {
                    this.log.warn("ListOffsets response includes unknown topic partition {}", (Object)topicPartition);
                    continue;
                }
                if (error == Errors.NONE) {
                    Optional<Integer> leaderEpoch = partition.leaderEpoch() == -1 ? Optional.empty() : Optional.of(partition.leaderEpoch());
                    completed.put(topicPartition, new ListOffsetsResult.ListOffsetsResultInfo(partition.offset(), partition.timestamp(), leaderEpoch));
                    continue;
                }
                this.handlePartitionError(topicPartition, error, failed, unmapped, retriable);
            }
        }
        for (TopicPartition topicPartition : keys) {
            if (!unmapped.isEmpty() || completed.containsKey(topicPartition) || failed.containsKey(topicPartition) || retriable.contains(topicPartition)) continue;
            ApiException sanityCheckException = new ApiException("The response from broker " + broker.id() + " did not contain a result for topic partition " + topicPartition);
            this.log.error("ListOffsets request for topic partition {} failed sanity check", (Object)topicPartition, (Object)sanityCheckException);
            failed.put(topicPartition, sanityCheckException);
        }
        return new AdminApiHandler.ApiResult<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo>(completed, failed, unmapped);
    }

    private void handlePartitionError(TopicPartition topicPartition, Errors error, Map<TopicPartition, Throwable> failed, List<TopicPartition> unmapped, Set<TopicPartition> retriable) {
        if (error == Errors.NOT_LEADER_OR_FOLLOWER || error == Errors.LEADER_NOT_AVAILABLE) {
            this.log.debug("ListOffsets lookup request for topic partition {} will be retried due to invalid leader metadata {}", (Object)topicPartition, (Object)error);
            unmapped.add(topicPartition);
        } else if (error.exception() instanceof RetriableException) {
            this.log.debug("ListOffsets fulfillment request for topic partition {} will be retried due to {}", (Object)topicPartition, (Object)error);
            retriable.add(topicPartition);
        } else {
            this.log.error("ListOffsets request for topic partition {} failed due to an unexpected error {}", (Object)topicPartition, (Object)error);
            failed.put(topicPartition, error.exception());
        }
    }

    @Override
    public Map<TopicPartition, Throwable> handleUnsupportedVersionException(int brokerId, UnsupportedVersionException exception, Set<TopicPartition> keys) {
        this.log.warn("Broker " + brokerId + " does not support MAX_TIMESTAMP offset specs");
        HashMap<TopicPartition, Throwable> maxTimestampPartitions = new HashMap<TopicPartition, Throwable>();
        for (TopicPartition topicPartition : keys) {
            Long offsetTimestamp = this.offsetTimestampsByPartition.get(topicPartition);
            if (offsetTimestamp != -3L) continue;
            maxTimestampPartitions.put(topicPartition, exception);
        }
        if (maxTimestampPartitions.isEmpty()) {
            return keys.stream().collect(Collectors.toMap(k -> k, k -> exception));
        }
        return maxTimestampPartitions;
    }

    public static AdminApiFuture.SimpleAdminApiFuture<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> newFuture(Collection<TopicPartition> topicPartitions) {
        return AdminApiFuture.forKeys(new HashSet<TopicPartition>(topicPartitions));
    }
}

