/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.kll;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.datasketches.kll.KllDoublesSketchBuildBufferAggregatorHelper;
import org.apache.druid.segment.vector.VectorValueSelector;

public class KllDoublesSketchBuildVectorAggregator
implements VectorAggregator {
    private final VectorValueSelector selector;
    private final KllDoublesSketchBuildBufferAggregatorHelper helper;

    KllDoublesSketchBuildVectorAggregator(VectorValueSelector selector, int size, int maxIntermediateSize) {
        this.selector = selector;
        this.helper = new KllDoublesSketchBuildBufferAggregatorHelper(size, maxIntermediateSize);
    }

    public void init(ByteBuffer buf, int position) {
        this.helper.init(buf, position);
    }

    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        double[] doubles = this.selector.getDoubleVector();
        boolean[] nulls = this.selector.getNullVector();
        KllDoublesSketch sketch = (KllDoublesSketch)this.helper.getSketchAtPosition(buf, position);
        for (int i = startRow; i < endRow; ++i) {
            if (nulls != null && nulls[i]) continue;
            sketch.update(doubles[i]);
        }
    }

    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        double[] doubles = this.selector.getDoubleVector();
        boolean[] nulls = this.selector.getNullVector();
        for (int i = 0; i < numRows; ++i) {
            int idx;
            int n = idx = rows != null ? rows[i] : i;
            if (nulls != null && nulls[idx]) continue;
            int position = positions[i] + positionOffset;
            ((KllDoublesSketch)this.helper.getSketchAtPosition(buf, position)).update(doubles[idx]);
        }
    }

    public Object get(ByteBuffer buf, int position) {
        return this.helper.get(buf, position);
    }

    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuf, ByteBuffer newBuf) {
        this.helper.relocate(oldPosition, newPosition, oldBuf, newBuf);
    }

    public void close() {
        this.helper.clear();
    }
}

