/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.timeline.partition.BuildingDimensionRangeShardSpec;
import org.apache.druid.timeline.partition.NumberedPartitionChunk;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.SingleDimensionShardSpec;

public class BuildingSingleDimensionShardSpec
extends BuildingDimensionRangeShardSpec {
    private final String dimension;
    @Nullable
    private final String start;
    @Nullable
    private final String end;

    @JsonCreator
    public BuildingSingleDimensionShardSpec(@JsonProperty(value="bucketId") int bucketId, @JsonProperty(value="dimension") String dimension, @JsonProperty(value="start") @Nullable String start, @JsonProperty(value="end") @Nullable String end, @JsonProperty(value="partitionNum") int partitionNum) {
        super(bucketId, dimension == null ? Collections.emptyList() : Collections.singletonList(dimension), start == null ? null : StringTuple.create(start), end == null ? null : StringTuple.create(end), partitionNum);
        this.dimension = dimension;
        this.start = start;
        this.end = end;
    }

    @JsonValue
    public Map<String, Object> getSerializableObject() {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("dimension", this.dimension);
        jsonMap.put("start", this.start);
        jsonMap.put("end", this.end);
        jsonMap.put("bucketId", this.getBucketId());
        jsonMap.put("partitionNum", this.getPartitionNum());
        return jsonMap;
    }

    public String getDimension() {
        return this.dimension;
    }

    @Nullable
    public String getStart() {
        return this.start;
    }

    @Nullable
    public String getEnd() {
        return this.end;
    }

    @Override
    public SingleDimensionShardSpec convert(int numCorePartitions) {
        return new SingleDimensionShardSpec(this.dimension, this.start, this.end, this.getPartitionNum(), (Integer)numCorePartitions);
    }

    @Override
    public <T> PartitionChunk<T> createChunk(T obj) {
        return new NumberedPartitionChunk<T>(this.getPartitionNum(), 0, obj);
    }

    @Override
    public String getType() {
        return "building_single_dim";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildingSingleDimensionShardSpec that = (BuildingSingleDimensionShardSpec)o;
        return this.getBucketId() == that.getBucketId() && this.getPartitionNum() == that.getPartitionNum() && Objects.equals(this.dimension, that.dimension) && Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getBucketId(), this.dimension, this.start, this.end, this.getPartitionNum());
    }

    @Override
    public String toString() {
        return "BuildingSingleDimensionShardSpec{bucketId=" + this.getBucketId() + ", dimension='" + this.dimension + "', start='" + this.start + "', end='" + this.end + "', partitionNum=" + this.getPartitionNum() + "}";
    }
}

