/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.shim;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DimensionSelectorUtils;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.RangeIndexedInts;
import org.apache.druid.segment.data.ZeroIndexedInts;
import org.apache.druid.segment.shim.ShimCursor;
import org.apache.druid.segment.vector.ReadableVectorInspector;
import org.apache.druid.segment.vector.VectorObjectSelector;

public class ShimVectorObjectDimSelector
implements DimensionSelector {
    private final ShimCursor cursor;
    private final ReadableVectorInspector vectorInspector;
    private final VectorObjectSelector vectorSelector;
    private final boolean hasMultipleValues;
    private Object[] objectVector;
    private int objectId = -1;

    public ShimVectorObjectDimSelector(ShimCursor cursor, VectorObjectSelector vectorSelector, boolean hasMultipleValues) {
        this.cursor = cursor;
        this.vectorInspector = cursor.vectorColumnSelectorFactory.getReadableVectorInspector();
        this.vectorSelector = vectorSelector;
        this.hasMultipleValues = hasMultipleValues;
    }

    @Override
    @Nullable
    public Object getObject() {
        this.populateObjectVector();
        return this.objectVector[this.cursor.currentIndexInVector];
    }

    @Override
    public Class<?> classOfObject() {
        return Object.class;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
    }

    private void populateObjectVector() {
        int id = this.vectorInspector.getId();
        if (id != this.objectId) {
            this.objectVector = this.vectorSelector.getObjectVector();
            this.objectId = id;
        }
    }

    @Override
    public IndexedInts getRow() {
        Object object = this.getObject();
        if (this.hasMultipleValues) {
            if (object == null) {
                return IndexedInts.empty();
            }
            if (object instanceof String) {
                return ZeroIndexedInts.instance();
            }
            if (object instanceof List) {
                List arrayList = (List)object;
                RangeIndexedInts rangeIndexedInts = new RangeIndexedInts();
                rangeIndexedInts.setSize(arrayList.size());
                return rangeIndexedInts;
            }
            throw DruidException.defensive("Found unexpected object type[%s]", object.getClass());
        }
        return ZeroIndexedInts.instance();
    }

    @Override
    public ValueMatcher makeValueMatcher(@Nullable String value) {
        return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, value);
    }

    @Override
    public ValueMatcher makeValueMatcher(DruidPredicateFactory predicateFactory) {
        return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, predicateFactory);
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return false;
    }

    @Override
    public int getValueCardinality() {
        return -1;
    }

    @Override
    @Nullable
    public String lookupName(int id) {
        Object object = this.getObject();
        if (this.hasMultipleValues && object instanceof List) {
            List arrayList = (List)object;
            object = arrayList.get(id);
        }
        return object == null ? null : object.toString();
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return null;
    }
}

