/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.RowBasedCursorFactory;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;

public class RowBasedSegment<RowType>
implements Segment {
    private final Sequence<RowType> rowSequence;
    private final RowAdapter<RowType> rowAdapter;
    private final RowSignature rowSignature;

    public RowBasedSegment(Sequence<RowType> rowSequence, RowAdapter<RowType> rowAdapter, RowSignature rowSignature) {
        this.rowSignature = (RowSignature)Preconditions.checkNotNull((Object)rowSignature, (Object)"rowSignature");
        this.rowSequence = (Sequence)Preconditions.checkNotNull(rowSequence, (Object)"rowSequence");
        this.rowAdapter = (RowAdapter)Preconditions.checkNotNull(rowAdapter, (Object)"rowAdapter");
    }

    @Override
    public SegmentId getId() {
        return null;
    }

    @Override
    @Nonnull
    public Interval getDataInterval() {
        return Intervals.ETERNITY;
    }

    @Override
    @Nullable
    public <T> T as(@Nonnull Class<T> clazz) {
        if (CursorFactory.class.equals(clazz)) {
            return (T)new RowBasedCursorFactory<RowType>(this.rowSequence, this.rowAdapter, this.rowSignature);
        }
        return null;
    }

    @Override
    public void close() {
    }
}

