/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.FilteredCursorFactory;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SimpleTopNOptimizationInspector;
import org.apache.druid.segment.TopNOptimizationInspector;
import org.apache.druid.segment.WrappedSegment;

public class FilteredSegment
extends WrappedSegment {
    @Nullable
    private final DimFilter filter;

    public FilteredSegment(Segment delegate, @Nullable DimFilter filter) {
        super(delegate);
        this.filter = filter;
    }

    @Override
    @Nullable
    public <T> T as(@Nonnull Class<T> clazz) {
        if (CursorFactory.class.equals(clazz)) {
            return (T)new FilteredCursorFactory(this.delegate.as(CursorFactory.class), this.filter);
        }
        if (TopNOptimizationInspector.class.equals(clazz)) {
            return (T)new SimpleTopNOptimizationInspector(this.filter == null);
        }
        return null;
    }

    @Override
    public String getDebugString() {
        return "filtered->" + this.delegate.getDebugString();
    }
}

