/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.RangeSet;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.filter.AbstractOptimizableDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.filter.IsBooleanFilter;

public abstract class IsBooleanDimFilter
extends AbstractOptimizableDimFilter {
    private final DimFilter field;
    private final boolean isTrue;

    public IsBooleanDimFilter(DimFilter field, boolean isTrue) {
        if (field == null) {
            throw DruidException.forPersona(DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build("IS %s operator requires a non-null filter for field", isTrue ? "TRUE" : "FALSE");
        }
        this.field = field;
        this.isTrue = isTrue;
    }

    @JsonProperty(value="field")
    public DimFilter getField() {
        return this.field;
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(21).appendBoolean(this.isTrue).appendCacheable(this.field).build();
    }

    @Override
    public Filter toFilter() {
        return new IsBooleanFilter(this.field.toFilter(), this.isTrue);
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        return null;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return this.field.getRequiredColumns();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IsBooleanDimFilter that = (IsBooleanDimFilter)o;
        if (this.field != null ? !this.field.equals(that.field) : that.field != null) {
            return false;
        }
        return this.isTrue == that.isTrue;
    }

    public int hashCode() {
        return Objects.hash(this.field, this.isTrue);
    }

    public String toString() {
        return "(" + String.valueOf(this.field) + ") IS " + (this.isTrue ? "TRUE" : "FALSE");
    }
}

