/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.expression.ExprUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class TimestampFormatExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "timestamp_format";

    @Override
    public String name() {
        return FN_NAME;
    }

    @Override
    public Expr apply(List<Expr> args) {
        String formatString;
        this.validationHelperCheckArgumentRange(args, 1, 3);
        final Expr arg = args.get(0);
        if (args.size() > 1) {
            this.validationHelperCheckArgIsLiteral(args.get(1), "format");
            formatString = (String)args.get(1).getLiteralValue();
        } else {
            formatString = null;
        }
        DateTimeZone timeZone = args.size() > 2 ? ExprUtils.toTimeZone(args.get(2)) : DateTimeZone.UTC;
        final DateTimeFormatter formatter = formatString == null ? ISODateTimeFormat.dateTime().withZone(timeZone) : DateTimeFormat.forPattern(formatString).withZone(timeZone);
        class TimestampFormatExpr
        extends ExprMacroTable.BaseScalarMacroFunctionExpr {
            private TimestampFormatExpr(List<Expr> args) {
                super(this$0, args);
            }

            @Override
            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                ExprEval eval = arg.eval(bindings);
                if (eval.isNumericNull()) {
                    return ExprEval.ofString(null);
                }
                return ExprEval.ofString(formatter.print(arg.eval(bindings).asLong()));
            }

            @Override
            @Nullable
            public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                return ExpressionType.STRING;
            }
        }
        return new TimestampFormatExpr(args);
    }
}

